/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui.details;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.ui.IDetailPane2;
import org.eclipse.debug.ui.IDetailPane3;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.ui.details.DatabaseDebugDetailEditor;
import org.jkiss.dbeaver.ui.ActionBars;
import org.jkiss.dbeaver.ui.Widgets;

public abstract class DatabaseDebugDetailPane<EDITOR extends DatabaseDebugDetailEditor>
implements IDetailPane2,
IDetailPane3 {
    private static final Log log = Log.getLog(DatabaseDebugDetailPane.class);
    private String name;
    private String description;
    private String id;
    private IWorkbenchPartSite partSite;
    private EDITOR editor;
    private Set<Integer> autoSaveProperties = new HashSet<Integer>();
    private ListenerList<IPropertyListener> propertyListeners = new ListenerList();
    private Composite editorParent;

    public DatabaseDebugDetailPane(String name, String description, String id) {
        this.name = name;
        this.description = description;
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void init(IWorkbenchPartSite partSite) {
        this.partSite = partSite;
    }

    public Control createControl(Composite parent) {
        this.editorParent = Widgets.createComposite((Composite)parent, (int)1, (int)1, (int)1808);
        this.editorParent.setBackground(parent.getDisplay().getSystemColor(25));
        this.editor = this.createEditor(this.editorParent);
        ((DatabaseDebugDetailEditor)this.editor).setMnemonics(false);
        ((DatabaseDebugDetailEditor)this.editor).addPropertyListener((source, propId) -> {
            if (this.autoSaveProperties.contains(propId)) {
                try {
                    ((DatabaseDebugDetailEditor)this.editor).doSave();
                    return;
                }
                catch (CoreException e) {
                    log.log(e.getStatus());
                }
            }
            this.firePropertyChange(257);
        });
        return ((DatabaseDebugDetailEditor)this.editor).createControl(this.editorParent);
    }

    protected abstract EDITOR createEditor(Composite var1);

    protected void registerAutosaveProperties(int[] autosave) {
        int[] nArray = autosave;
        int n = autosave.length;
        int n2 = 0;
        while (n2 < n) {
            int anAutosave = nArray[n2];
            this.autoSaveProperties.add(anAutosave);
            ++n2;
        }
    }

    protected void unregisterAutosaveProperties(int[] autosave) {
        int[] nArray = autosave;
        int n = autosave.length;
        int n2 = 0;
        while (n2 < n) {
            int anAutosave = nArray[n2];
            this.autoSaveProperties.remove(anAutosave);
            ++n2;
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    public boolean setFocus() {
        return false;
    }

    public void display(IStructuredSelection selection) {
        IStatusLineManager statusLine = ActionBars.extractStatusLineManager((IWorkbenchSite)this.partSite);
        if (statusLine != null) {
            statusLine.setErrorMessage(null);
        }
        EDITOR editor = this.getEditor();
        Object input = null;
        if (selection != null && selection.size() == 1) {
            input = selection.getFirstElement();
        }
        try {
            ((DatabaseDebugDetailEditor)editor).setInput(input);
        }
        catch (CoreException e) {
            log.log(e.getStatus());
        }
    }

    protected EDITOR getEditor() {
        return this.editor;
    }

    public boolean isDirty() {
        return this.editor != null && ((DatabaseDebugDetailEditor)this.editor).isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        IStatusLineManager statusLine = ActionBars.extractStatusLineManager((IWorkbenchSite)this.partSite);
        if (statusLine != null) {
            statusLine.setErrorMessage(null);
        }
        try {
            ((DatabaseDebugDetailEditor)this.editor).doSave();
        }
        catch (CoreException e) {
            if (statusLine != null) {
                statusLine.setErrorMessage(e.getMessage());
            }
            log.log(e.getStatus());
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty() && ((DatabaseDebugDetailEditor)this.editor).getStatus().isOK();
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    protected void firePropertyChange(int property) {
        for (IPropertyListener listener : this.propertyListeners) {
            listener.propertyChanged((Object)this, property);
        }
    }

    public void dispose() {
        this.editor = null;
        this.partSite = null;
        this.propertyListeners.clear();
        this.autoSaveProperties.clear();
        this.editorParent.dispose();
    }
}

