/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetColumn;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferSession;
import org.jkiss.utils.CommonUtils;

public class StreamTransferResultSet
implements DBCResultSet {
    private final StreamTransferSession session;
    private final DBCStatement statement;
    private StreamProducerSettings.EntityMapping entityMapping;
    private List<DBCAttributeMetaData> metaAttrs;
    private Object[] streamRow;
    private final List<StreamProducerSettings.AttributeMapping> attributeMappings;
    private final int[] targetToSourceMap;
    private DateTimeFormatter dateTimeFormat;

    public StreamTransferResultSet(StreamTransferSession session, DBCStatement statement, StreamProducerSettings.EntityMapping entityMapping) {
        this.session = session;
        this.statement = statement;
        this.entityMapping = entityMapping;
        this.attributeMappings = this.entityMapping.getAttributeMappings();
        this.metaAttrs = new ArrayList<DBCAttributeMetaData>(this.attributeMappings.size());
        this.targetToSourceMap = new int[this.entityMapping.getValuableAttributeMappings().size()];
        int mapIndex = 0;
        int i = 0;
        while (i < this.attributeMappings.size()) {
            StreamProducerSettings.AttributeMapping attr = this.attributeMappings.get(i);
            if (attr.isValuable()) {
                this.metaAttrs.add((DBCAttributeMetaData)new LocalResultSetColumn((DBCResultSet)this, i, attr.getTargetAttributeName(), DBPDataKind.STRING));
                this.targetToSourceMap[mapIndex++] = i;
            }
            ++i;
        }
    }

    public void setStreamRow(Object[] streamRow) {
        this.streamRow = streamRow;
    }

    public DBCSession getSession() {
        return this.session;
    }

    public DBCStatement getSourceStatement() {
        return this.statement;
    }

    public Object getAttributeValue(int index) throws DBCException {
        int sourceIndex = this.targetToSourceMap[index];
        StreamProducerSettings.AttributeMapping attr = this.attributeMappings.get(sourceIndex);
        if (attr.getMappingType() == StreamProducerSettings.AttributeMapping.MappingType.DEFAULT_VALUE) {
            return attr.getDefaultValue();
        }
        Object value = this.streamRow[attr.getSourceAttributeIndex()];
        if (value != null && this.dateTimeFormat != null && attr.getTargetAttribute() != null && attr.getTargetAttribute().getDataKind() == DBPDataKind.DATETIME) {
            try {
                TemporalAccessor ta = this.dateTimeFormat.parse(CommonUtils.toString((Object)value));
                try {
                    ZonedDateTime zdt = ZonedDateTime.from(ta);
                    value = Date.from(zdt.toInstant());
                }
                catch (Exception exception) {
                    LocalDateTime localDT = LocalDateTime.from(ta);
                    if (localDT != null) {
                        value = Date.from(localDT.atZone(ZoneId.systemDefault()).toInstant());
                    }
                }
            }
            catch (Exception exception) {}
        }
        return value;
    }

    public Object getAttributeValue(String name) throws DBCException {
        return null;
    }

    public DBDValueMeta getAttributeValueMeta(int index) throws DBCException {
        return null;
    }

    public DBDValueMeta getRowMeta() throws DBCException {
        return null;
    }

    public boolean nextRow() throws DBCException {
        return false;
    }

    public boolean moveTo(int position) throws DBCException {
        return false;
    }

    public DBCResultSetMetaData getMeta() throws DBCException {
        return new LocalResultSetMeta(this.metaAttrs);
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        return null;
    }

    public void close() {
    }

    public DateTimeFormatter getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(DateTimeFormatter dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }
}

