/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.UUID;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Bits {
    private static final VarHandle INT_VH = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
    private static final VarHandle LONG_VH = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);

    public static int compareNotNullSigned(byte[] byArray, byte[] byArray2) {
        return Integer.signum(Arrays.compare(byArray, byArray2));
    }

    public static int compareNotNullUnsigned(byte[] byArray, byte[] byArray2) {
        return Integer.signum(Arrays.compareUnsigned(byArray, byArray2));
    }

    public static int readInt(byte[] byArray, int n) {
        return INT_VH.get(byArray, n);
    }

    public static long readLong(byte[] byArray, int n) {
        return LONG_VH.get(byArray, n);
    }

    public static byte[] uuidToBytes(long l, long l2) {
        byte[] byArray = new byte[16];
        LONG_VH.set(byArray, 0, l);
        LONG_VH.set(byArray, 8, l2);
        return byArray;
    }

    public static byte[] uuidToBytes(UUID uUID) {
        return Bits.uuidToBytes(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
    }

    public static void writeInt(byte[] byArray, int n, int n2) {
        INT_VH.set(byArray, n, n2);
    }

    public static void writeLong(byte[] byArray, int n, long l) {
        LONG_VH.set(byArray, n, l);
    }

    private Bits() {
    }
}

