/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.testing;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.testing.IWhiteBoxTestable;

public class TestController {
    private Multimap<Class<? extends ILayoutProcessor<?>>, ILayoutPreProcessorListener> procPreListeners = HashMultimap.create();
    private Multimap<Class<? extends ILayoutProcessor<?>>, ILayoutPostProcessorListener> procPostListeners = HashMultimap.create();
    private Multimap<Class<? extends ILayoutProcessor<?>>, ILayoutPreProcessorListener> procRootPreListeners = HashMultimap.create();
    private Multimap<Class<? extends ILayoutProcessor<?>>, ILayoutPostProcessorListener> procRootPostListeners = HashMultimap.create();
    private String layoutAlgorithmId;

    public TestController(String layoutAlgorithmId) {
        this.layoutAlgorithmId = layoutAlgorithmId;
    }

    public String getTargetAlgorithmId() {
        return this.layoutAlgorithmId;
    }

    public boolean targets(LayoutAlgorithmData algorithmData) {
        return algorithmData.getId().equals(this.layoutAlgorithmId);
    }

    public void install(AbstractLayoutProvider layoutProvider) {
        if (!(layoutProvider instanceof IWhiteBoxTestable)) {
            throw new IllegalArgumentException("Test controllers can only be installed on white-box testable layout algorithms");
        }
        ((IWhiteBoxTestable)((Object)layoutProvider)).setTestController(this);
    }

    public void notifyProcessorReady(Object lgraph, ILayoutProcessor<?> processor) {
        Collection listeners = this.procPreListeners.get(processor.getClass());
        for (ILayoutPreProcessorListener listener : listeners) {
            listener.layoutProcessorReady(lgraph, processor);
        }
    }

    public void notifyProcessorFinished(Object lgraph, ILayoutProcessor<?> processor) {
        Collection listeners = this.procPostListeners.get(processor.getClass());
        for (ILayoutPostProcessorListener listener : listeners) {
            listener.layoutProcessorFinished(lgraph, processor);
        }
    }

    public void notifyRootProcessorReady(Object lgraph, ILayoutProcessor<?> processor) {
        Collection listeners = this.procRootPreListeners.get(processor.getClass());
        for (ILayoutPreProcessorListener listener : listeners) {
            listener.layoutProcessorReady(lgraph, processor);
        }
    }

    public void notifyRootProcessorFinished(Object lgraph, ILayoutProcessor<?> processor) {
        Collection listeners = this.procRootPostListeners.get(processor.getClass());
        for (ILayoutPostProcessorListener listener : listeners) {
            listener.layoutProcessorFinished(lgraph, processor);
        }
    }

    public void addPreProcessorRunListener(ILayoutPreProcessorListener listener, Class<? extends ILayoutProcessor<?>> processor, boolean onRoot) {
        if (onRoot) {
            this.procRootPreListeners.put(processor, (Object)listener);
        } else {
            this.procPreListeners.put(processor, (Object)listener);
        }
    }

    public void addPostProcessorRunListener(ILayoutPostProcessorListener listener, Class<? extends ILayoutProcessor<?>> processor, boolean onRoot) {
        if (onRoot) {
            this.procRootPostListeners.put(processor, (Object)listener);
        } else {
            this.procPostListeners.put(processor, (Object)listener);
        }
    }

    public static interface ILayoutPostProcessorListener {
        public void layoutProcessorFinished(Object var1, ILayoutProcessor<?> var2);
    }

    public static interface ILayoutPreProcessorListener {
        public void layoutProcessorReady(Object var1, ILayoutProcessor<?> var2);
    }
}

