/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class SelfLoopPreProcessor
implements ILayoutProcessor<LGraph> {
    private static final double EPSILON = 1.0E-6;

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Self-Loop pre-processing.", 1.0f);
        Direction layoutDirection = (Direction)layeredGraph.getProperty(LayeredOptions.DIRECTION);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            SelfLoopNode slNode = new SelfLoopNode(node);
            node.setProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION, slNode);
            SelfLoopComponent.createSelfLoopComponents(slNode);
            this.preprocessLabels(slNode, layoutDirection);
            this.hidePorts(node);
        }
        monitor.done();
    }

    public void preprocessLabels(SelfLoopNode slNode, Direction layoutDirection) {
        boolean verticalLayout = layoutDirection.isVertical();
        double labelLabelSpacing = LGraphUtil.getIndividualOrInherited(slNode.getNode(), LayeredOptions.SPACING_LABEL_LABEL);
        for (SelfLoopComponent component : slNode.getSelfLoopComponents()) {
            List labels = component.getConnectedEdges().stream().filter(edge -> ((Object)((Object)edge.getEdge().getSource().getNode())).equals((Object)edge.getEdge().getTarget().getNode())).flatMap(edge -> edge.getEdge().getLabels().stream()).sorted(new Comparator<LLabel>(){

                @Override
                public int compare(LLabel o1, LLabel o2) {
                    return DoubleMath.fuzzyCompare((double)o1.getSize().x, (double)o2.getSize().x, (double)1.0E-6);
                }
            }).collect(Collectors.toList());
            if (labels.isEmpty()) continue;
            double width = 0.0;
            double height = 0.0;
            for (LLabel label : labels) {
                KVector size = label.getSize();
                if (verticalLayout) {
                    width += size.x;
                    height = Math.max(size.y, height);
                    continue;
                }
                width = Math.max(size.x, width);
                height += size.y;
            }
            double combinedLabelLabelSpacing = Math.max(0.0, labelLabelSpacing * (double)(labels.size() - 1));
            if (verticalLayout) {
                width += combinedLabelLabelSpacing;
            } else {
                height += combinedLabelLabelSpacing;
            }
            SelfLoopLabel label = new SelfLoopLabel();
            label.getLabels().addAll(labels);
            label.setHeight(height);
            label.setWidth(width);
            component.setSelfLoopLabel(label);
        }
    }

    private void hidePorts(LNode node) {
        ArrayList<LPort> selfLoopPorts = new ArrayList<LPort>();
        for (LPort port : node.getPorts()) {
            Iterable<LEdge> edges = port.getConnectedEdges();
            boolean containsNonSelfloop = false;
            for (LEdge edge : edges) {
                if (edge.isSelfLoop()) continue;
                containsNonSelfloop = true;
                break;
            }
            if (containsNonSelfloop) continue;
            selfLoopPorts.add(port);
        }
        node.getPorts().removeAll(selfLoopPorts);
        for (LPort port : selfLoopPorts) {
            LNode dummy = (LNode)((Object)port.getProperty(InternalProperties.PORT_DUMMY));
            if (dummy == null) continue;
            Layer layer = dummy.getLayer();
            if (layer == null) {
                dummy.getGraph().getLayerlessNodes().remove((Object)dummy);
                continue;
            }
            layer.getNodes().remove((Object)dummy);
            if (!layer.getNodes().isEmpty()) continue;
            layer.getGraph().getLayers().remove(layer);
        }
    }
}

