/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabelPosition;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.SelfLoopComponentMerger;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.SelfLoopLabelPositionEvaluator;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.SelfLoopLabelPositionGeneration;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class SelfLoopLabelPlacer
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Self-Loop Label Placement", 1.0f);
        Direction layoutDirection = (Direction)layeredGraph.getProperty(LayeredOptions.DIRECTION);
        for (Layer layer : layeredGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                if (node.getType() != LNode.NodeType.NORMAL) continue;
                SelfLoopNode slNode = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
                if (((Boolean)layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING_MERGE_SELF_LOOPS)).booleanValue()) {
                    SelfLoopComponentMerger.mergeComponents(slNode);
                }
                SelfLoopLabelPositionGeneration.generatePositions(slNode);
                SelfLoopLabelPositionEvaluator evaluator = new SelfLoopLabelPositionEvaluator(slNode);
                evaluator.evaluatePositions();
                this.placeLabels(slNode, layoutDirection);
            }
        }
        monitor.done();
    }

    private void placeLabels(SelfLoopNode slNode, Direction layoutDirection) {
        boolean verticalLayout = layoutDirection.isVertical();
        double labelLabelSpacing = LGraphUtil.getIndividualOrInherited(slNode.getNode(), LayeredOptions.SPACING_LABEL_LABEL);
        for (SelfLoopComponent component : slNode.getSelfLoopComponents()) {
            SelfLoopLabel slLabel = component.getSelfLoopLabel();
            if (slLabel == null) continue;
            if (verticalLayout) {
                this.placeLabelsForVerticalLayout(slLabel, labelLabelSpacing, layoutDirection);
                continue;
            }
            this.placeLabelsForHorizontalLayout(slLabel, labelLabelSpacing);
        }
    }

    private void placeLabelsForHorizontalLayout(SelfLoopLabel slLabel, double labelLabelSpacing) {
        SelfLoopLabelPosition slPosition = slLabel.getLabelPosition();
        KVector currCoordinates = slPosition.getPosition();
        for (LLabel lLabel : slLabel.getLabels()) {
            double xPos = currCoordinates.x;
            switch (slPosition.getLabelAlignment()) {
                case CENTERED: {
                    xPos += (slLabel.getWidth() - lLabel.getSize().x) / 2.0;
                    break;
                }
                case RIGHT: {
                    xPos += slLabel.getWidth() - lLabel.getSize().x;
                }
            }
            lLabel.getPosition().set(xPos, currCoordinates.y);
            currCoordinates.y += lLabel.getSize().y + labelLabelSpacing;
        }
    }

    private void placeLabelsForVerticalLayout(SelfLoopLabel slLabel, double labelLabelSpacing, Direction layoutDirection) {
        SelfLoopLabelPosition slPosition = slLabel.getLabelPosition();
        KVector currCoordinates = slPosition.getPosition();
        List labels = slLabel.getLabels();
        if (layoutDirection == Direction.UP) {
            labels = Lists.reverse(labels);
        }
        for (LLabel lLabel : labels) {
            double yPos = currCoordinates.y;
            switch (slPosition.getLabelAlignment()) {
                case CENTERED: {
                    yPos += (slLabel.getHeight() - lLabel.getSize().y) / 2.0;
                    break;
                }
                case LEFT: {
                    yPos += slLabel.getWidth() - lLabel.getSize().x;
                }
            }
            lLabel.getPosition().set(currCoordinates.x, yPos);
            currCoordinates.x += lLabel.getSize().x + labelLabelSpacing;
        }
    }
}

