/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryExpression;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;

class VQBPanelQueryOrderBy
extends VQBPanelQueryExpression<OrderByElement> {
    public static final String DIRECTION_ASCENDING = "Ascending";
    public static final String DIRECTION_DESCENDING = "Descending";

    protected VQBPanelQueryOrderBy(VQBEditorPresentation presentation) {
        super(presentation);
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, OrderByElement> columnsController) {
        columnsController.addColumn("#", "Element position", 16384, true, true, orderByElement -> {
            PlainSelect selectBody = this.getPlainSelect();
            if (selectBody != null) {
                return String.valueOf(selectBody.getOrderByElements().indexOf(orderByElement) + 1);
            }
            return null;
        }, null);
        VQBPanelQueryElements.ExpressionEditingSupport<OrderByElement> columnEditSupport = new VQBPanelQueryElements.ExpressionEditingSupport<OrderByElement>((VQBPanelQueryElements)this){

            @Override
            protected CellEditor getCellEditor(Object element) {
                CustomComboBoxCellEditor cellEditor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryOrderBy.this.elementViewer, (Composite)VQBPanelQueryOrderBy.this.elementViewer.getTree(), new String[0], 4);
                List<String> attrNames = VQBUtils.getAttributeNames(VQBPanelQueryOrderBy.this.presentation.getVQBEditor().getDiagram(), false);
                cellEditor.setItems(attrNames.toArray(new String[attrNames.size()]));
                TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryOrderBy.this.presentation.getSQLEditor().getSite(), (Control)cellEditor.getControl());
                return cellEditor;
            }

            @Override
            protected String convertExpressionToString(OrderByElement orderByElement) {
                return orderByElement.getExpression().toString();
            }

            @Override
            protected boolean updateElementExpression(OrderByElement parent, OrderByElement orderByElement, Expression expression) {
                orderByElement.setExpression(expression);
                return true;
            }
        };
        columnsController.addColumn("Column or Expression", "Expression", 16384, true, true, orderByElement -> orderByElement.getExpression().toString(), (EditingSupport)columnEditSupport);
        EditingSupport ascDescEditingSupport = new EditingSupport((ColumnViewer)this.elementViewer){

            protected CellEditor getCellEditor(Object element) {
                CustomComboBoxCellEditor editor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryOrderBy.this.elementViewer, (Composite)VQBPanelQueryOrderBy.this.elementViewer.getTree(), new String[0], 12);
                editor.setItems(new String[]{VQBPanelQueryOrderBy.DIRECTION_ASCENDING, VQBPanelQueryOrderBy.DIRECTION_DESCENDING});
                return editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((OrderByElement)element).isAsc() ? VQBPanelQueryOrderBy.DIRECTION_ASCENDING : VQBPanelQueryOrderBy.DIRECTION_DESCENDING;
            }

            protected void setValue(Object element, Object value) {
                ((OrderByElement)element).setAsc(VQBPanelQueryOrderBy.DIRECTION_ASCENDING.equals(value));
                VQBPanelQueryOrderBy.this.refreshDiagramAndStatement();
            }
        };
        columnsController.addColumn("Order", "Order", 16384, true, false, element -> element.isAsc() ? DIRECTION_ASCENDING : DIRECTION_DESCENDING, ascDescEditingSupport);
    }

    @Override
    protected List<OrderByElement> extractRootItems(PlainSelect inputElement) {
        return inputElement.getOrderByElements();
    }

    @Override
    protected Expression getExpression(OrderByElement orderByElement) {
        return orderByElement.getExpression();
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return UIIcon.SORT;
    }

    @Override
    protected void fillPanelContributions(IContributionManager contributionManager) {
        super.fillPanelContributions(contributionManager);
        contributionManager.add((IAction)new Action("Add Column/Expression", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD)){

            public void run() {
                PlainSelect plainSelect = VQBPanelQueryOrderBy.this.getPlainSelect();
                if (plainSelect != null) {
                    ArrayList<OrderByElement> orderByElements = plainSelect.getOrderByElements();
                    if (orderByElements == null) {
                        orderByElements = new ArrayList<OrderByElement>();
                        plainSelect.setOrderByElements(orderByElements);
                    }
                    OrderByElement selectedItem = (OrderByElement)VQBPanelQueryOrderBy.this.getSelectedElement();
                    OrderByElement newElement = new OrderByElement();
                    newElement.setExpression((Expression)new LongValue(1L));
                    if (selectedItem != null) {
                        orderByElements.add(orderByElements.indexOf(selectedItem) + 1, newElement);
                    } else {
                        orderByElements.add(newElement);
                    }
                    VQBPanelQueryOrderBy.this.addNewElement(newElement, 1);
                }
            }
        });
        contributionManager.add((IAction)new VQBPanelQueryElements.DeleteActionAbstract(this){

            protected List<OrderByElement> getElementsContainer() {
                PlainSelect plainSelect = VQBPanelQueryOrderBy.this.getPlainSelect();
                return plainSelect != null ? plainSelect.getOrderByElements() : null;
            }
        });
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new Action("Move Up", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_UP)){

            public void run() {
                VQBPanelQueryOrderBy.this.moveElementTo(-1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQueryOrderBy.this.getPlainSelect();
                OrderByElement selectedElement = (OrderByElement)VQBPanelQueryOrderBy.this.getSelectedElement();
                return plainSelect != null && plainSelect.getOrderByElements() != null && selectedElement != null && plainSelect.getOrderByElements().indexOf(selectedElement) > 0;
            }
        });
        contributionManager.add((IAction)new Action("Move Down", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_DOWN)){

            public void run() {
                VQBPanelQueryOrderBy.this.moveElementTo(1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQueryOrderBy.this.getPlainSelect();
                OrderByElement selectedElement = (OrderByElement)VQBPanelQueryOrderBy.this.getSelectedElement();
                return plainSelect != null && plainSelect.getOrderByElements() != null && selectedElement != null && plainSelect.getOrderByElements().indexOf(selectedElement) < plainSelect.getSelectItems().size() - 1;
            }
        });
    }

    private void moveElementTo(int shift) {
        List orderByElements;
        PlainSelect plainSelect;
        OrderByElement selectedElement = (OrderByElement)this.getSelectedElement();
        if (selectedElement != null && (plainSelect = this.getPlainSelect()) != null && (orderByElements = plainSelect.getOrderByElements()) != null) {
            int oldIndex = orderByElements.indexOf(selectedElement);
            if (orderByElements.remove(selectedElement)) {
                orderByElements.add(oldIndex + shift, selectedElement);
                this.presentation.getQueryPanel().refreshActions();
                this.refreshDiagramAndStatement();
            }
        }
    }

    @Override
    protected boolean supportsElementsMove() {
        return true;
    }

    @Override
    protected void moveElementTo(OrderByElement srcElement, OrderByElement dstElement) {
        List orderByElements = this.getPlainSelect().getOrderByElements();
        if (orderByElements != null) {
            orderByElements.indexOf(srcElement);
            int newIndex = orderByElements.indexOf(dstElement);
            if (orderByElements.remove(srcElement)) {
                orderByElements.add(newIndex, srcElement);
                this.presentation.getQueryPanel().refreshActions();
                this.refreshDiagramAndStatement();
            }
        }
    }
}

