/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.provider;

import com.dbeaver.ui.editors.sql.plan.diagram.features.PlansCollapseDummyFeature;
import com.dbeaver.ui.editors.sql.plan.diagram.features.PlansDetailInfoFeature;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRenderInfo;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.ContextEntryHelper;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;

public class PlansToolBehaviorProvider
extends DefaultToolBehaviorProvider {
    public PlansToolBehaviorProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    private PlanNodeRenderInfo getRenderInfo(PictogramElement pe) {
        if (pe == null) {
            return null;
        }
        if (pe.getLink() == null) {
            return null;
        }
        for (Object o : pe.getLink().getBusinessObjects()) {
            if (!(o instanceof PlanNodeRenderInfo)) continue;
            return (PlanNodeRenderInfo)((Object)o);
        }
        return null;
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        IContextButtonPadData data = super.getContextButtonPad(context);
        PictogramElement pictogramElement = context.getPictogramElement();
        data.getGenericContextButtons().clear();
        CustomContext customContext = new CustomContext(new PictogramElement[]{pictogramElement});
        ICustomFeature[] customFeature = this.getFeatureProvider().getCustomFeatures((ICustomContext)customContext);
        int i = 0;
        while (i < customFeature.length) {
            ICustomFeature iCustomFeature = customFeature[i];
            if (iCustomFeature instanceof PlansCollapseDummyFeature) {
                IContextButtonEntry collapseButton = ContextEntryHelper.createCollapseContextButton((!((PlansCollapseDummyFeature)iCustomFeature).isCollapsed() ? 1 : 0) != 0, (IFeature)iCustomFeature, (IContext)customContext);
                data.setCollapseContextButton(collapseButton);
            } else if (iCustomFeature instanceof PlansDetailInfoFeature) {
                ContextButtonEntry buttonDemo = new ContextButtonEntry((IFeature)iCustomFeature, (IContext)customContext);
                buttonDemo.setText("Detail");
                buttonDemo.setIconId("org.eclipse.graphiti.eclipse.information");
                data.getDomainSpecificContextButtons().add(buttonDemo);
            }
            ++i;
        }
        return data;
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        ContextMenuEntry subMenu = new ContextMenuEntry(null, (IContext)context);
        subMenu.setText("Cu&stom");
        subMenu.setDescription("Custom features submenu");
        subMenu.setSubmenu(true);
        ICustomFeature[] customFeatures = this.getFeatureProvider().getCustomFeatures(context);
        int i = 0;
        while (i < customFeatures.length) {
            ICustomFeature customFeature = customFeatures[i];
            if (customFeature.isAvailable((IContext)context)) {
                ContextMenuEntry menuEntry = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
                subMenu.add((IContextMenuEntry)menuEntry);
            }
            ++i;
        }
        IContextMenuEntry[] ret = new IContextMenuEntry[]{subMenu};
        return ret;
    }

    public IPaletteCompartmentEntry[] getPalette() {
        ArrayList ret = new ArrayList();
        return ret.toArray(new IPaletteCompartmentEntry[ret.size()]);
    }

    public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof EObject) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            if (invisible.getGraphicsAlgorithmChildren().size() == 0) {
                return super.getClickArea(pe);
            }
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }
        return super.getClickArea(pe);
    }

    public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
        EList graphicsAlgorithmChildren;
        GraphicsAlgorithm invisible;
        if (pe instanceof ContainerShape && !(invisible = pe.getGraphicsAlgorithm()).getLineVisible().booleanValue() && !(graphicsAlgorithmChildren = invisible.getGraphicsAlgorithmChildren()).isEmpty()) {
            return (GraphicsAlgorithm)graphicsAlgorithmChildren.get(0);
        }
        return super.getSelectionBorder(pe);
    }

    public Object getToolTip(GraphicsAlgorithm ga) {
        PlanNodeRenderInfo renderInfo = this.getRenderInfo(ga.getPictogramElement());
        if (renderInfo != null) {
            return renderInfo.getNode().getText();
        }
        return super.getToolTip(ga);
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        return new PlansDetailInfoFeature(this.getFeatureProvider());
    }
}

