/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResultQuery;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;

class SchemaMigration {
    private final CMPOptions options;
    private final CMPResultQuery[] resultQueries;

    public SchemaMigration(CMPOptions options, CMPResultQuery[] resultQueries) {
        this.options = options;
        this.resultQueries = resultQueries;
    }

    public void runMigration(DBRProgressMonitor monitor) throws CMPException {
        monitor.beginTask("Perform schema migration", this.resultQueries.length);
        monitor.subTask("Open session");
        DBPDataSource dataSource = this.options.getTargetInput().getDataSourceContainer().getDataSource();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Schema migration");){
                CMPResultQuery[] cMPResultQueryArray = this.resultQueries;
                int n = this.resultQueries.length;
                int n2 = 0;
                while (n2 < n) {
                    CMPResultQuery query = cMPResultQueryArray[n2];
                    if (monitor.isCanceled()) break;
                    monitor.subTask(query.getChangeItem().getFullyQualifiedName(DBPEvaluationContext.UI));
                    try {
                        DBCStatement dbStat = session.prepareStatement(DBCStatementType.SCRIPT, query.getQuery(), false, false, false);
                        dbStat.executeStatement();
                    }
                    catch (DBCException e) {
                        DBPPlatformUI.UserResponse userResponse = DBWorkbench.getPlatformUI().showErrorStopRetryIgnore("Schema migration", (Throwable)e, true);
                        switch (userResponse) {
                            case CANCEL: 
                            case STOP: {
                                throw e;
                            }
                        }
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new CMPException("Schema migration error", (Throwable)e);
        }
    }
}

