/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import com.dbeaver.ee.scmp.impl.liquibase.LBObjectDataType;
import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class LBObjectChangeFilter
implements ObjectChangeFilter {
    private final CMPOptions options;
    private final SQLDataSource sqlDataSource;
    private final Database lbDatabase;
    private final Map<String, List<DBSObject>> inputObjects = new HashMap<String, List<DBSObject>>();
    private final Map<String, DBSObjectContainer> outputObjects = new HashMap<String, DBSObjectContainer>();

    public LBObjectChangeFilter(CMPOptions options, Database lbDatabase) throws CMPException {
        this.options = options;
        DBPDataSource dataSource = options.getSourceInput().getDataSourceContainer().getDataSource();
        if (!(dataSource instanceof SQLDataSource)) {
            throw new CMPException("Input datasource must be a SQL datasource");
        }
        this.sqlDataSource = (SQLDataSource)dataSource;
        this.lbDatabase = lbDatabase;
        for (DBSObject object : options.getSourceInput().getInputObjects()) {
            if (object instanceof DBSObjectContainer) {
                this.inputObjects.computeIfAbsent(this.getContainerName((DBSObjectContainer)object), dbsObjectContainer -> new ArrayList());
                continue;
            }
            if (object == null) continue;
            DBSObjectContainer objectContainer = (DBSObjectContainer)DBUtils.getParentOfType(DBSObjectContainer.class, (DBSObject)object);
            List objects = this.inputObjects.computeIfAbsent(this.getContainerName(objectContainer), dbsObjectContainer -> new ArrayList());
            objects.add(object);
        }
        for (DBSObject object : options.getTargetInput().getInputObjects()) {
            if (!(object instanceof DBSObjectContainer)) continue;
            this.outputObjects.put(this.getContainerName((DBSObjectContainer)object), (DBSObjectContainer)object);
        }
    }

    private String getContainerName(DBSObjectContainer object) {
        if (object instanceof DBPDataSource) {
            return "";
        }
        ArrayList<String> fqNames = new ArrayList<String>();
        DBSObjectContainer co = object;
        while (co != null) {
            if (co instanceof DBPDataSource | co instanceof DBPDataSourceContainer) break;
            String objectName = DBUtils.getQuotedIdentifier((SQLDataSource)this.sqlDataSource, (String)co.getName(), (boolean)true, (boolean)true);
            fqNames.add(0, objectName);
            co = co.getParentObject();
        }
        return String.join((CharSequence)this.sqlDataSource.getSQLDialect().getCatalogSeparator(), fqNames);
    }

    private String getContainerName(DatabaseObject object) {
        Catalog catalog;
        Schema schema = object.getSchema();
        Catalog catalog2 = catalog = schema == null ? null : schema.getCatalog();
        if (schema == null && catalog == null) {
            return "";
        }
        ArrayList<String> fqNames = new ArrayList<String>();
        if (catalog != null && this.lbDatabase.supportsCatalogs()) {
            fqNames.add(DBUtils.getQuotedIdentifier((SQLDataSource)this.sqlDataSource, (String)catalog.getName(), (boolean)true, (boolean)true));
        }
        if (schema != null && this.lbDatabase.supportsSchemas()) {
            fqNames.add(DBUtils.getQuotedIdentifier((SQLDataSource)this.sqlDataSource, (String)schema.getName(), (boolean)true, (boolean)true));
        }
        return String.join((CharSequence)this.sqlDataSource.getSQLDialect().getCatalogSeparator(), fqNames);
    }

    private boolean containsObject(DatabaseObject object) {
        if (LBObjectDataType.isTableAttributes(object)) {
            return this.containsObject(object.getContainingObjects()[0]);
        }
        String containerName = this.getContainerName(object);
        List<DBSObject> objectList = this.inputObjects.get(containerName);
        if (objectList == null) {
            DatabaseObject[] containingObjects = object.getContainingObjects();
            if (containingObjects != null) {
                DatabaseObject[] databaseObjectArray = containingObjects;
                int n = containingObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    DatabaseObject co = databaseObjectArray[n2];
                    if (!this.containsObject(co)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }
        if (objectList.isEmpty()) {
            return true;
        }
        for (DBSObject incObject : objectList) {
            if (!CommonUtils.equalObjects((Object)incObject.getName(), (Object)object.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean includeMissing(DatabaseObject object, Database referenceDatabase, Database comparisionDatabase) {
        if (!this.options.isDoCreate()) {
            return false;
        }
        return this.containsObject(object);
    }

    public boolean includeUnexpected(DatabaseObject object, Database referenceDatabase, Database comparisionDatabase) {
        if (!this.options.isDoDrop()) {
            return false;
        }
        String targetContainerName = this.getContainerName(object);
        DBSObjectContainer outContainer = this.outputObjects.get(targetContainerName);
        if (outContainer == null) {
            return false;
        }
        DBSObjectContainer sourceContainer = this.options.getSourceContainer(outContainer);
        if (sourceContainer == null) {
            return false;
        }
        String sourceContainerName = this.getContainerName(sourceContainer);
        List<DBSObject> sourceObjects = this.inputObjects.get(sourceContainerName);
        if (sourceObjects == null) {
            return false;
        }
        return sourceObjects.isEmpty();
    }

    public boolean includeChanged(DatabaseObject object, ObjectDifferences differences, Database referenceDatabase, Database comparisionDatabase) {
        if (!this.options.isDoChange()) {
            return false;
        }
        return this.containsObject(object);
    }

    public boolean include(DatabaseObject object) {
        return this.containsObject(object);
    }
}

