/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.model.document;

import com.dbeaver.ee.model.document.DBMapValue;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;

public abstract class DBAbstractDocument<DATASOURCE extends DBPDataSource, SOURCE_TYPE>
implements DBDDocument,
DBDComposite {
    private static final Log log = Log.getLog(DBAbstractDocument.class);
    @NotNull
    protected final DATASOURCE dataSource;
    protected SOURCE_TYPE rawValue;
    protected DBMapValue<DATASOURCE> rawMap;

    public DBAbstractDocument(@NotNull DATASOURCE dataSource, SOURCE_TYPE rawValue) {
        this.dataSource = dataSource;
        this.rawValue = rawValue;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    @NotNull
    public Object getRootNode() {
        if (this.rawMap == null) {
            this.rawMap = this.makeRawMap();
        }
        return this.rawMap;
    }

    protected abstract DBMapValue<DATASOURCE> makeRawMap();

    public SOURCE_TYPE getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
    }

    public DBSDataType getDataType() {
        return null;
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, Object value) {
    }

    protected static class DocumentAttribute
    implements DBSAttributeBase {
        private int position;
        private String name;

        public DocumentAttribute(int position, String name) {
            this.position = position;
            this.name = name;
        }

        public String getTypeName() {
            return "document";
        }

        public String getFullTypeName() {
            return "document";
        }

        public int getTypeID() {
            return 0;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.DOCUMENT;
        }

        public Integer getScale() {
            return null;
        }

        public Integer getPrecision() {
            return null;
        }

        public long getMaxLength() {
            return 0L;
        }

        public int getOrdinalPosition() {
            return this.position;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

