/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.exec;

import com.dbeaver.ee.redis.exec.RedisSession;
import com.dbeaver.ee.redis.model.RedisDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import redis.clients.jedis.Jedis;

public class RedisExecutionContext
extends AbstractExecutionContext<RedisDataSource> {
    public RedisExecutionContext(RedisDataSource dataSource, String purpose) {
        super((DBPDataSource)dataSource, purpose);
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((RedisDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open redis session");
                Throwable throwable = null;
                Object var5_7 = null;
                try (Jedis jedis = this.acquireJedis();){
                    jedis.ping();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                super.initContextBootstrap(monitor, true);
                ((RedisDataSource)this.dataSource).addExecutionContext(this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, this.dataSource);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((RedisDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public RedisSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new RedisSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Jedis jedis = this.acquireJedis();){
                jedis.ping();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new DBException("Error pinging Redis", e);
        }
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RedisExecutionContext redisExecutionContext = this;
        synchronized (redisExecutionContext) {
            ((RedisDataSource)this.dataSource).removeExecutionContext(this);
            super.closeContext();
        }
    }

    Jedis acquireJedis() {
        SSLHandlerTrustStoreImpl.setGlobalTrustStore((DBPDataSource)this.getDataSource());
        return ((RedisDataSource)this.dataSource).getJedisPool().getResource();
    }
}

