/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.model;

import com.dbeaver.ee.redis.RedisConstants;
import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.exec.RedisBaseResultSet;
import com.dbeaver.ee.redis.exec.RedisKeyGetStatement;
import com.dbeaver.ee.redis.exec.RedisKeySetStatement;
import com.dbeaver.ee.redis.exec.RedisKeySizeStatement;
import com.dbeaver.ee.redis.exec.RedisSession;
import com.dbeaver.ee.redis.model.RedisDataSource;
import com.dbeaver.ee.redis.model.RedisDatabase;
import com.dbeaver.ee.redis.model.RedisKeyAttribute;
import com.dbeaver.ee.redis.model.RedisKeyNameConstraint;
import com.dbeaver.ee.redis.model.RedisKeyScoredConstraint;
import com.dbeaver.ee.redis.model.RedisKeySimpleConstraint;
import com.dbeaver.ee.redis.model.RedisKeyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class RedisKey
implements DBSEntity,
DBSDataContainer,
DBSDataManipulator,
DBPSaveableObject,
DBPQualifiedObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(RedisKey.class);
    private static final List<RedisKey> EMPTY_SUB_KEYS = Collections.emptyList();
    private final RedisDatabase database;
    private final RedisKey parentKey;
    private final String keyName;
    private RedisKeyType keyType;
    private Long ttl;
    private long keySize = -1L;
    private boolean isFolder;
    private boolean persisted;
    private List<RedisKey> subKeys;
    private List<RedisKeyAttribute> attributes = null;

    public RedisKey(@NotNull RedisDatabase database, @Nullable RedisKey parentKey, @NotNull String keyName, boolean isFolder) {
        this.database = database;
        this.parentKey = parentKey;
        this.keyName = keyName;
        this.isFolder = isFolder;
        this.persisted = true;
    }

    @Association
    @Nullable
    public RedisKey getParentKey() {
        return this.parentKey;
    }

    @NotNull
    public RedisDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.keyName;
    }

    public RedisDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public RedisKeyType getKeyType(DBRProgressMonitor monitor) {
        if (this.keyType == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Read key [" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "] type"));){
                    RedisUtils.selectCurDatabase(session.getJedis(), this.getDatabase());
                    this.keyType = RedisKeyType.valueOf(session.getJedis().type(this.getFullyQualifiedName(DBPEvaluationContext.DML)));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error getting key type", e);
                this.keyType = RedisKeyType.string;
            }
        }
        return this.keyType;
    }

    @Property(viewable=false, order=3)
    public long getTTL(DBRProgressMonitor monitor) {
        if (this.ttl == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Read key [" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "] TTL"));){
                    RedisUtils.selectCurDatabase(session.getJedis(), this.getDatabase());
                    this.ttl = session.getJedis().ttl(this.getFullyQualifiedName(DBPEvaluationContext.DML));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
            if (this.ttl == null) {
                this.ttl = -1L;
            }
        }
        return this.ttl;
    }

    @Property(viewable=false, order=4)
    public long getKeySize(DBRProgressMonitor monitor) throws DBCException {
        if (this.keySize < 0L) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Count key size");){
                RedisUtils.selectCurDatabase(session.getJedis(), this.getDatabase());
                this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, DBUtils.getDefaultContext((DBSObject)this, (boolean)true), (Object)this), (DBCSession)session, null, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.keySize;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.parentKey != null ? this.parentKey : this.getDataSource().getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    @Association
    public List<RedisKey> getKeys(DBRProgressMonitor monitor) throws DBCException {
        if (this.subKeys == null) {
            this.subKeys = RedisUtils.getKeys(monitor, this.database, this, null, true);
        }
        return this.subKeys;
    }

    public void setSubKeys(List<String> keys, String divider) {
        if (keys == null) {
            return;
        }
        if (keys.isEmpty()) {
            if (this.subKeys == null) {
                this.subKeys = EMPTY_SUB_KEYS;
            }
            return;
        }
        for (String key : keys) {
            this.addSubKey(key, divider);
        }
    }

    private void addSubKey(String key, String divider) {
        String keyName;
        String subKey;
        int divPos;
        if (this.subKeys == null) {
            this.subKeys = new ArrayList<RedisKey>();
        }
        if ((divPos = key.indexOf(divider)) != -1) {
            subKey = key.substring(divPos + 1);
            keyName = key.substring(0, divPos);
        } else {
            keyName = key;
            subKey = null;
        }
        RedisKey child = null;
        for (RedisKey k : this.subKeys) {
            if (!k.keyName.equals(keyName)) continue;
            child = k;
            break;
        }
        if (child == null) {
            child = new RedisKey(this.database, this, keyName, subKey != null);
            this.subKeys.add(child);
        }
        if (subKey != null) {
            super.addSubKey(subKey, divider);
        }
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (this.parentKey == null) {
            return this.getName();
        }
        String keyDivider = this.getDataSource().getKeyDivider();
        StringBuilder fqn = new StringBuilder();
        RedisKey key = this;
        while (key != null) {
            if (fqn.length() > 0) {
                fqn.insert(0, keyDivider);
            }
            fqn.insert(0, key.keyName);
            key = key.parentKey;
        }
        return fqn.toString();
    }

    public int getSupportedFeatures() {
        return 458752;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        if (firstRow > 0L) {
            return new DBCStatistics();
        }
        try {
            Throwable throwable = null;
            Object var13_11 = null;
            try {
                RedisKeyGetStatement keyStatement = new RedisKeyGetStatement((RedisSession)session, this, firstRow, maxRows);
                try {
                    keyStatement.executeStatement();
                    Throwable throwable2 = null;
                    Object var16_16 = null;
                    try {
                        DBCStatistics dBCStatistics;
                        RedisBaseResultSet resultSet = keyStatement.openResultSet();
                        dataReceiver.fetchStart(session, (DBCResultSet)resultSet, firstRow, maxRows);
                        DBCStatistics statistics = new DBCStatistics();
                        int rowFetched = 0;
                        long startTime = System.currentTimeMillis();
                        while (true) {
                            if (!resultSet.nextRow()) {
                                statistics.setFetchTime(System.currentTimeMillis() - startTime);
                                statistics.setRowsFetched((long)rowFetched);
                                statistics.setStatementsCount(1);
                                dBCStatistics = statistics;
                                break;
                            }
                            dataReceiver.fetchRow(session, (DBCResultSet)resultSet);
                            ++rowFetched;
                        }
                        if (keyStatement != null) {
                            keyStatement.close();
                        }
                        dataReceiver.close();
                        return dBCStatistics;
                        {
                            finally {
                                dataReceiver.fetchEnd(session, (DBCResultSet)resultSet);
                            }
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (keyStatement == null) throw throwable4;
                    keyStatement.close();
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            dataReceiver.close();
            throw throwable;
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        if (this.keySize < 0L) {
            Throwable throwable = null;
            Object var7_7 = null;
            try (RedisKeySizeStatement keyStatement = new RedisKeySizeStatement((RedisSession)session, this.getFullyQualifiedName(DBPEvaluationContext.DML), this.getKeyType(session.getProgressMonitor()));){
                keyStatement.executeStatement();
                this.keySize = keyStatement.getKeySize();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.keySize;
    }

    public DBSDataManipulator.ExecuteBatch insertData(DBCSession session, DBSAttributeBase[] attributes, DBDDataReceiver keysReceiver, DBCExecutionSource source) throws DBCException {
        if (this.getKeyType(session.getProgressMonitor()) == RedisKeyType.string) {
            throw new DBCException("Can't add second value to string key");
        }
        return this.updateData(session, null, attributes, keysReceiver, source);
    }

    public DBSDataManipulator.ExecuteBatch updateData(DBCSession session, DBSAttributeBase[] updateAttributes, final DBSAttributeBase[] keyAttributes, DBDDataReceiver keysReceiver, DBCExecutionSource source) throws DBCException {
        return new ExecuteBatchImpl(keyAttributes, null, false, updateAttributes){
            boolean isInsert;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.isInsert = dBSAttributeBaseArray == null;
            }

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues) throws DBCException {
                return new RedisKeySetStatement((RedisSession)session, RedisKey.this, RedisKey.this.getKeyType(session.getProgressMonitor()), ArrayUtils.isEmpty((Object[])keyAttributes) ? null : keyAttributes[0].getName(), null);
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                RedisKeySetStatement setStatement = (RedisKeySetStatement)statement;
                if (attributeValues.length > 1) {
                    setStatement.setName(CommonUtils.toString((Object)attributeValues[this.isInsert ? 0 : 1]));
                }
                if (attributeValues.length == 1) {
                    setStatement.setValue(attributeValues[0]);
                } else {
                    setStatement.setValue(attributeValues[this.isInsert ? 1 : 0]);
                }
            }
        };
    }

    public DBSDataManipulator.ExecuteBatch deleteData(DBCSession session, DBSAttributeBase[] keyAttributes, DBCExecutionSource source) throws DBCException {
        return new ExecuteBatchImpl(keyAttributes, null, false){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues) throws DBCException {
                return new RedisKeySetStatement((RedisSession)session, RedisKey.this, RedisKey.this.getKeyType(session.getProgressMonitor()), null, null);
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                String nameOrValue = CommonUtils.toString((Object)(attributeValues.length > 1 ? attributeValues[1] : attributeValues[0]));
                ((RedisKeySetStatement)statement).setName(nameOrValue);
            }
        };
    }

    public DBCStatistics truncateData(DBCSession session, DBCExecutionSource source) throws DBCException {
        throw new DBCException("Truncate not supported");
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        this.keyType = null;
        this.ttl = null;
        this.keySize = -1L;
        this.subKeys = null;
        return this;
    }

    public DBSEntityType getEntityType() {
        return RedisConstants.TYPE_KEY;
    }

    public List<RedisKeyAttribute> getAttributes(DBRProgressMonitor monitor) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<RedisKeyAttribute>();
            switch (this.getKeyType(monitor)) {
                case string: {
                    this.attributes.add(new RedisKeyAttribute(this, "output", 0));
                    break;
                }
                case set: {
                    this.attributes.add(new RedisKeyAttribute(this, "value", 1));
                    break;
                }
                case zset: {
                    this.attributes.add(new RedisKeyAttribute(this, "score", 1));
                    this.attributes.add(new RedisKeyAttribute(this, "value", 1));
                    break;
                }
                default: {
                    this.attributes.add(new RedisKeyAttribute(this, "name", 0));
                    this.attributes.add(new RedisKeyAttribute(this, "value", 1));
                }
            }
        }
        return this.attributes;
    }

    public DBSEntityAttribute getAttribute(DBRProgressMonitor monitor, String attributeName) throws DBException {
        return (DBSEntityAttribute)DBUtils.findObject((List)this.getAttributes(monitor), (String)attributeName);
    }

    public List<RedisKeySimpleConstraint> getConstraints(DBRProgressMonitor monitor) throws DBException {
        RedisKeySimpleConstraint constraint;
        switch (this.getKeyType(monitor)) {
            case string: {
                constraint = new RedisKeySimpleConstraint(this);
                break;
            }
            case zset: {
                constraint = new RedisKeyScoredConstraint(this);
                break;
            }
            default: {
                constraint = new RedisKeyNameConstraint(this);
            }
        }
        return Collections.singletonList(constraint);
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(DBRProgressMonitor monitor) throws DBException {
        return null;
    }
}

