/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis;

import com.dbeaver.ee.redis.exec.RedisSession;
import com.dbeaver.ee.redis.model.RedisDatabase;
import com.dbeaver.ee.redis.model.RedisKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;

public class RedisUtils {
    private static final Log log;
    public static final List<String> NULL_SUB_KEYS;
    public static Map<String, Method[]> COMMAND_METHODS;

    static {
        Method[] jedisMethods;
        log = Log.getLog(RedisUtils.class);
        NULL_SUB_KEYS = Collections.emptyList();
        COMMAND_METHODS = new HashMap<String, Method[]>();
        Method[] methodArray = jedisMethods = Jedis.class.getMethods();
        int n = jedisMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !method.isAnnotationPresent(Deprecated.class) && method.getReturnType() != byte[].class) {
                boolean hasBadParams = false;
                Class<?>[] classArray = method.getParameterTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> paramType = classArray[n4];
                    if (paramType.isArray()) {
                        hasBadParams = true;
                        break;
                    }
                    ++n4;
                }
                if (!hasBadParams) {
                    String commandName = method.getName().toLowerCase(Locale.ENGLISH);
                    Object[] methods = COMMAND_METHODS.get(commandName);
                    methods = methods == null ? new Method[]{method} : (Method[])ArrayUtils.add(Method.class, (Object[])methods, (Object)method);
                    COMMAND_METHODS.put(commandName, (Method[])methods);
                }
            }
            ++n2;
        }
    }

    public static Map<String, Object> parseInfo(String info) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new StringReader(info));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.isEmpty()) {
                        break;
                    }
                    int divPos = line.indexOf(58);
                    if (divPos == -1) continue;
                    String name = line.substring(0, divPos);
                    String value = line.substring(divPos + 1);
                    map.put(name, value);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return map;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static List<RedisKey> getKeys(@NotNull DBRProgressMonitor monitor, @NotNull RedisDatabase database, @Nullable RedisKey parent, @Nullable String pattern, boolean showHierarchy) throws DBCException {
        dataSource = database.getDataSource();
        props = database.getDataSource().getContainer().getConnectionConfiguration();
        divider = database.getDataSource().getKeyDivider();
        if (parent != null && !showHierarchy) {
            return Collections.emptyList();
        }
        maxKeys = CommonUtils.toInt((Object)props.getProviderProperty("@dbeaver-redis.key.read.count"), (int)10000);
        maxPatternRead = CommonUtils.toInt((Object)props.getProviderProperty("@dbeaver-redis.pattern.read.count"), (int)100000);
        dataSource.getDefaultObject();
        monitor.beginTask("Read keys", 1);
        try {
            var10_10 = null;
            var11_12 = null;
            try {
                session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)database, (String)"Read keys");
                try {
                    jedis = session.getJedis();
                    RedisUtils.selectCurDatabase(jedis, database);
                    params = new ScanParams();
                    cursorPattern = null;
                    parentName = null;
                    if (parent != null) {
                        parentName = parent.getFullyQualifiedName(DBPEvaluationContext.DML);
                        cursorPattern = String.valueOf(parentName) + divider;
                        cursorPattern = !CommonUtils.isEmpty((String)pattern) ? String.valueOf(cursorPattern) + pattern : String.valueOf(cursorPattern) + "*";
                    } else if (!CommonUtils.isEmpty((String)pattern)) {
                        cursorPattern = pattern;
                    }
                    if (cursorPattern != null) {
                        params.match(cursorPattern);
                        params.count(Integer.valueOf(maxPatternRead));
                    } else {
                        params.count(Integer.valueOf(maxKeys));
                    }
                    keyMap = new TreeMap<String, List<String>>();
                    totalKeysRead = 0;
                    totalIterations = 0;
                    cursorId = "0";
                    RedisUtils.log.debug((Object)("Read Redis keys " + cursorPattern));
                    while (!monitor.isCanceled()) {
                        scanResult = jedis.scan(cursorId, params);
                        cursorId = scanResult.getStringCursor();
                        ++totalIterations;
                        scanKeys = scanResult.getResult();
                        for (String keyName : scanKeys) {
                            if (totalKeysRead++ >= maxKeys) break;
                            if (parent != null && showHierarchy && keyName.startsWith(parentName) && (keyName = keyName.substring(parentName.length())).startsWith(divider)) {
                                keyName = keyName.substring(divider.length());
                            }
                            divPos = showHierarchy != false ? keyName.indexOf(divider) : -1;
                            subKey = null;
                            if (divPos != -1) {
                                subKey = keyName.substring(divPos + 1);
                                keyName = keyName.substring(0, divPos);
                            }
                            if (subKey != null) {
                                subKeys = (ArrayList<String>)keyMap.get(keyName);
                                if (subKeys == null || subKeys == RedisUtils.NULL_SUB_KEYS) {
                                    subKeys = new ArrayList<String>();
                                    keyMap.put(keyName, subKeys);
                                }
                                subKeys.add(subKey);
                                continue;
                            }
                            if (keyMap.containsKey(keyName)) continue;
                            keyMap.put(keyName, RedisUtils.NULL_SUB_KEYS);
                        }
                        if (totalKeysRead++ >= maxKeys || cursorId.equals("0")) break;
                    }
                    RedisUtils.log.debug((Object)("Read " + totalKeysRead + " keys in " + totalIterations + " iterations"));
                    readAll = totalKeysRead < maxKeys;
                    keys = new ArrayList<RedisKey>();
                    for (Map.Entry keyEntry : keyMap.entrySet()) {
                        redisKey = new RedisKey(database, parent, (String)keyEntry.getKey(), ((List)keyEntry.getValue()).isEmpty() == false);
                        keys.add(redisKey);
                        if (!readAll) continue;
                        Collections.sort((List)keyEntry.getValue());
                        redisKey.setSubKeys((List)keyEntry.getValue(), divider);
                    }
                    var29_32 = keys;
                    ** try [egrp 3[TRYBLOCK] [1 : 828->837)] { 
                }
lbl86:
                // 1 sources

                catch (Throwable var10_11) {
                    throw var10_11;
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
lbl-1000:
                // 1 sources

                {
                    monitor.done();
                    return var29_32;
                }
            }
            catch (Throwable var11_13) {
                if (var10_10 == null) {
                    var10_10 = var11_13;
                } else if (var10_10 != var11_13) {
                    var10_10.addSuppressed(var11_13);
                }
                throw var10_10;
            }
        }
        catch (Throwable var28_33) {
            monitor.done();
            throw var28_33;
        }
    }

    public static void selectCurDatabase(RedisSession session) {
        RedisUtils.selectCurDatabase(session.getJedis(), session.getDataSource().getDefaultObject());
    }

    public static void selectCurDatabase(Jedis jedis, @NotNull RedisDatabase database) {
        if (database.getDataSource().getDatabases().size() < 2) {
            return;
        }
        jedis.select(database.getId());
    }

    public static boolean isCommand(String command) {
        return COMMAND_METHODS.containsKey(command);
    }
}

