/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb;

import com.dbeaver.ee.mongodb.data.MongoListValue;
import com.dbeaver.ee.mongodb.data.MongoMapValue;
import com.dbeaver.ee.mongodb.model.MGCollection;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.PasswordEncrypter;
import org.jkiss.dbeaver.runtime.encode.SimpleStringEncrypter;
import org.jkiss.utils.CommonUtils;

public class MongoUtils {
    private static final Log log = Log.getLog(MongoUtils.class);
    private static PasswordEncrypter ENCRYPTER = new SimpleStringEncrypter();
    public static final String OPER_NE = "$ne";
    public static final String OPER_GT = "$gt";
    public static final String OPER_GTE = "$gte";
    public static final String OPER_LT = "$lt";
    public static final String OPER_LTE = "$lte";
    public static final String OPER_REGEX = "$regex";

    @Nullable
    public static DBObject makeQueryFromFilter(@NotNull MongoDataSource dataSource, @Nullable DBDDataFilter filter) throws DBCException {
        if (filter == null || !filter.hasConditions()) {
            return null;
        }
        StringBuilder condString = new StringBuilder();
        SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (StringBuilder)condString, (boolean)true);
        try {
            Expression expr = CCJSqlParserUtil.parseCondExpression((String)condString.toString());
            return MongoUtils.convertExpressionToObject(expr);
        }
        catch (JSQLParserException e) {
            throw new DBCException("Bad filter conditions", (Throwable)e);
        }
    }

    @NotNull
    public static String makeSQLQuery(@NotNull MGCollection collection, @Nullable DBDDataFilter filter) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML));
        if (filter != null && filter.hasConditions()) {
            sql.append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (StringBuilder)sql, (boolean)true);
        }
        if (filter != null && filter.hasOrdering()) {
            sql.append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (StringBuilder)sql);
        }
        return sql.toString();
    }

    public static int resolveValueType(Object value) {
        if (value instanceof CharSequence) {
            return 3;
        }
        if (value instanceof Number) {
            return 4;
        }
        if (value instanceof Boolean) {
            return 5;
        }
        if (value instanceof Date) {
            return 6;
        }
        if (value instanceof byte[]) {
            return 7;
        }
        if (value instanceof Collection) {
            return 8;
        }
        if (value instanceof Map) {
            return 2;
        }
        return 9;
    }

    public static Object wrapMongoValue(MongoDataSource dataSource, Object value, Object parent) {
        if (value instanceof BasicDBObject) {
            return new MongoMapValue(dataSource, (DBObject)((BasicDBObject)value), parent);
        }
        if (value instanceof BasicDBList) {
            return new MongoListValue(dataSource, (BasicDBList)value);
        }
        if (value instanceof ObjectId) {
            return value.toString();
        }
        return value;
    }

    public static Object unwrapMongoValue(DBSAttributeBase attribute, Object value) {
        if (value instanceof MongoMapValue) {
            return ((MongoMapValue)((Object)value)).getRawValue();
        }
        if (value instanceof MongoListValue) {
            return ((MongoListValue)value).getRawValue();
        }
        if (value instanceof String && attribute.getName().equals("_id")) {
            ObjectId objectId;
            if (ObjectId.isValid((String)((String)value)) && (objectId = new ObjectId((String)value)).getTimestamp() > 0) {
                return objectId;
            }
            return value;
        }
        return value;
    }

    public static Object convertValueExpressionToObject(Expression expression) throws DBCException {
        if (expression instanceof StringValue) {
            return expression.toString();
        }
        if (expression instanceof LongValue) {
            return ((LongValue)expression).getValue();
        }
        if (expression instanceof DoubleValue) {
            return ((DoubleValue)expression).getValue();
        }
        if (expression instanceof DateValue) {
            return ((DateValue)expression).getValue();
        }
        if (expression instanceof TimestampValue) {
            return ((TimestampValue)expression).getValue();
        }
        return expression.toString();
    }

    public static DBObject convertExpressionToObject(Expression expression) throws DBCException {
        BasicDBObject object = new BasicDBObject();
        MongoUtils.parseExpression(object, expression);
        return object;
    }

    private static void parseExpression(BasicDBObject owner, Expression expr) throws DBCException {
        if (expr instanceof AndExpression) {
            MongoUtils.parseExpression(owner, ((AndExpression)expr).getLeftExpression());
            MongoUtils.parseExpression(owner, ((AndExpression)expr).getRightExpression());
        } else {
            if (expr instanceof InExpression) {
                throw new DBCException("IN conditions not supported: " + expr);
            }
            if (expr instanceof OrExpression) {
                throw new DBCException("OR conditions not supported: " + expr);
            }
            if (expr instanceof BinaryExpression) {
                MongoUtils.parseBinaryExpression(owner, (BinaryExpression)expr);
            } else if (expr instanceof Parenthesis) {
                MongoUtils.parseExpression(owner, ((Parenthesis)expr).getExpression());
            } else {
                throw new DBCException("Unsupported expression: " + expr);
            }
        }
    }

    private static void parseBinaryExpression(BasicDBObject owner, BinaryExpression expr) throws DBCException {
        String operator;
        Expression left = expr.getLeftExpression();
        if (!(left instanceof Column)) {
            throw new DBCException("Unsupported left operand: " + left);
        }
        Column column = (Column)left;
        String fieldName = MongoUtils.unquote(column.getFullyQualifiedName());
        Object fieldValue = MongoUtils.parseValueExpression(expr.getRightExpression());
        if (expr instanceof EqualsTo) {
            operator = null;
        } else if (expr instanceof NotEqualsTo) {
            operator = OPER_NE;
        } else if (expr instanceof GreaterThan) {
            operator = OPER_GT;
        } else if (expr instanceof GreaterThanEquals) {
            operator = OPER_GTE;
        } else if (expr instanceof MinorThan) {
            operator = OPER_LT;
        } else if (expr instanceof MinorThanEquals) {
            operator = OPER_LTE;
        } else if (expr instanceof LikeExpression) {
            operator = OPER_REGEX;
        } else {
            throw new DBCException("Unsupported operation: " + expr.getStringExpression());
        }
        MongoUtils.makeObjectCondition(owner, fieldName, fieldValue, operator);
    }

    private static void makeObjectCondition(BasicDBObject owner, String fieldName, Object fieldValue, String operator) {
        if (fieldName.equals("_id") && fieldValue instanceof String) {
            try {
                fieldValue = new ObjectId((String)fieldValue);
            }
            catch (Exception exception) {}
        }
        Object value = operator == null ? fieldValue : new BasicDBObject(operator, fieldValue);
        owner.put((Object)fieldName, value);
    }

    private static Object parseValueExpression(Expression expr) throws DBCException {
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        if (expr instanceof LongValue) {
            return ((LongValue)expr).getValue();
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof TimestampValue) {
            return ((TimestampValue)expr).getValue();
        }
        if (expr instanceof TimeValue) {
            return ((TimeValue)expr).getValue();
        }
        if (expr instanceof DateValue) {
            return ((DateValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String literal = MongoUtils.unquote(((Column)expr).getFullyQualifiedName());
            if (literal.equals("true") || literal.equals("false")) {
                return Boolean.valueOf(literal);
            }
            throw new DBCException("Unexpected literal: " + expr);
        }
        if (expr instanceof Function) {
            String funcName = ((Function)expr).getName();
            ExpressionList parameters = ((Function)expr).getParameters();
            if ("ObjectId".equals(funcName)) {
                if (parameters.getExpressions().size() != 1) {
                    throw new DBCException("ObjectId must have 1 parameter");
                }
                return new ObjectId(CommonUtils.toString((Object)MongoUtils.parseValueExpression((Expression)parameters.getExpressions().get(0))));
            }
            throw new DBCException("Unsupported function: " + funcName);
        }
        throw new DBCException("Unsupported value: " + expr);
    }

    public static String unquote(String name) {
        return name.replace("\"", "");
    }

    public static String toJSON(Map<String, Object> object, boolean preview) {
        return object == null ? "[NULL]" : object.toString();
    }

    public static String saveAuthInfo(String userName, String userDB, String userPassword) {
        if (CommonUtils.isEmpty((String)userName)) {
            return null;
        }
        try {
            return String.valueOf(userName) + "|" + userDB + "|" + ENCRYPTER.encrypt(userPassword);
        }
        catch (EncryptionException encryptionException) {
            return String.valueOf(userName) + "|" + userDB + "|" + userPassword;
        }
    }

    public static String[] extractAuthInfo(String tokens) {
        String[] authTokens = tokens.split("\\|");
        try {
            return new String[]{authTokens[0], authTokens[1], ENCRYPTER.decrypt(authTokens[2])};
        }
        catch (EncryptionException encryptionException) {
            return new String[]{authTokens[0], authTokens[1], authTokens[2]};
        }
    }

    public static String saveSeedInfo(String host, String port) {
        return String.valueOf(host) + "|" + port;
    }

    public static String[] extractSeedInfo(String tokens) {
        String[] authTokens = tokens.split("\\|");
        return new String[]{authTokens[0], authTokens[1]};
    }

    @NotNull
    public static DBObject cloneObject(Object object) {
        if (object instanceof BasicDBObject) {
            return (BasicDBObject)((BasicDBObject)object).copy();
        }
        if (object instanceof BasicDBList) {
            return (BasicDBList)((BasicDBList)object).copy();
        }
        if (object instanceof DBObject) {
            return (DBObject)object;
        }
        throw new IllegalArgumentException("Can't copy object [" + object + "]");
    }
}

