/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.model;

import com.dbeaver.ee.mongodb.model.MGDatabase;
import com.dbeaver.ee.mongodb.model.MGOperation;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCSession;

public class MGOperationManager
implements DBAServerSessionManager<MGOperation> {
    public static final String PROP_KILL_QUERY = "killQuery";
    private final MongoDataSource dataSource;

    public MGOperationManager(MongoDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public Collection<MGOperation> getSessions(DBCSession session, Map<String, Object> options) throws DBException {
        MGDatabase adminDB = this.dataSource.getDatabase("admin");
        if (adminDB == null) {
            throw new DBException("Admin database not found");
        }
        List inprog = null;
        if (this.dataSource.isServerVersionAtLeast(3, 2)) {
            Document opList = adminDB.getDatabase().runCommand((Bson)new Document("currentOp", (Object)1));
            inprog = (List)opList.get((Object)"inprog");
        } else {
            DB adminDbClient = adminDB.getDB();
            if (adminDbClient == null) {
                throw new DBException("Admin database object not found");
            }
            DBCollection inprogCollection = adminDbClient.getCollection("$cmd.sys.inprog");
            DBCursor cur = inprogCollection.find((DBObject)new BasicDBObject("$all", (Object)1));
            if (cur.hasNext()) {
                inprog = (List)cur.next().get("inprog");
            }
        }
        if (inprog == null) {
            throw new DBException("Can't find inprog list");
        }
        ArrayList<MGOperation> operations = new ArrayList<MGOperation>();
        for (Object anInprog : inprog) {
            LinkedHashMap<String, Object> map;
            if (anInprog instanceof DBObject) {
                map = new LinkedHashMap<String, Object>();
                DBObject dbObject = (DBObject)anInprog;
                for (String key : dbObject.keySet()) {
                    map.put(key, dbObject.get(key));
                }
            } else {
                map = (LinkedHashMap<String, Object>)anInprog;
            }
            operations.add(new MGOperation(this.dataSource, map));
        }
        return operations;
    }

    public void alterSession(DBCSession session, MGOperation mongoOperation, Map<String, Object> options) throws DBException {
    }
}

