/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.data.handlers;

import com.dbeaver.ee.mongodb.data.MongoContentBytes;
import com.dbeaver.ee.mongodb.data.handlers.MongoBaseValueHandler;
import com.dbeaver.ee.mongodb.exec.MongoCustomStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import java.nio.ByteBuffer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoContentValueHandler
extends MongoBaseValueHandler {
    public static final MongoContentValueHandler INSTANCE = new MongoContentValueHandler();

    @NotNull
    public Class<DBDContent> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBDContent.class;
    }

    public MongoContentBytes getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        MongoSession mongoSession = (MongoSession)session;
        if (object == null) {
            return new MongoContentBytes(mongoSession.getDataSource());
        }
        if (object instanceof MongoContentBytes) {
            MongoContentBytes src = (MongoContentBytes)((Object)object);
            return copy ? new MongoContentBytes(mongoSession.getDataSource(), src.getData()) : src;
        }
        if (object instanceof ByteBuffer) {
            return new MongoContentBytes(mongoSession.getDataSource(), (ByteBuffer)object);
        }
        if (object instanceof byte[]) {
            return new MongoContentBytes(mongoSession.getDataSource(), ByteBuffer.wrap((byte[])object));
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(MongoSession session, MongoCustomStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBDContent) {
            String result = ((DBDContent)value).getDisplayString(format);
            if (result == null) {
                return super.getValueDisplayString(column, null, format);
            }
            return result;
        }
        return super.getValueDisplayString(column, value, format);
    }
}

