/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.adv.generator;

import com.dbeaver.ee.mockdata.adv.generator.StringNameGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mockdata.MockDataUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class StringEmailGenerator
extends StringNameGenerator {
    private static final Log log = Log.getLog(StringEmailGenerator.class);
    private static List<String> MAIL_DOMAINS;
    private static int mailDomains;
    private Random random = new Random();
    private int numericSuffixSize = 2;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        super.init(container, attribute, properties);
        Integer suffix = (Integer)properties.get("numericSuffixSize");
        if (suffix != null) {
            this.numericSuffixSize = suffix;
        }
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        Object value;
        if (mailDomains == 0) {
            MAIL_DOMAINS = this.readDict("mail_domains.txt");
            mailDomains = MAIL_DOMAINS.size();
        }
        if ((value = super.generateOneValue(monitor)) == null) {
            return null;
        }
        String name = (String)value;
        if (this.numericSuffixSize > 0) {
            name = String.valueOf(name) + String.format(".%0" + this.numericSuffixSize + "d", MockDataUtils.getRandomInt((int)0, (int)MockDataUtils.degree((int)this.numericSuffixSize), (Random)this.random));
        }
        String mailSuffix = "@" + MAIL_DOMAINS.get(this.random.nextInt(mailDomains));
        if (this.withSurnames) {
            return String.valueOf(name.replace(' ', '.')) + mailSuffix;
        }
        return String.valueOf(name) + mailSuffix;
    }
}

