/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;

public class DynamoTableAttribute
implements DBSEntityAttribute,
DBSTableColumn {
    private static final Log log = Log.getLog(DynamoTableAttribute.class);
    private final DynamoTable table;
    private boolean persisted;
    private final AttributeDefinition definition;

    public DynamoTableAttribute(DynamoTable table, AttributeDefinition definition) {
        this.table = table;
        this.definition = definition;
        this.persisted = true;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    @NotNull
    public DynamoDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.definition.attributeName();
    }

    public String getDescription() {
        return null;
    }

    public DynamoTable getParentObject() {
        return this.table;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }

    public String getDefaultValue() {
        return null;
    }

    public int getOrdinalPosition() {
        return -1;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @Property(viewable=true, order=2)
    public String getTypeName() {
        return this.definition.attributeTypeAsString();
    }

    public String getFullTypeName() {
        return this.getTypeName();
    }

    public int getTypeID() {
        return this.definition.attributeType().ordinal();
    }

    public DBPDataKind getDataKind() {
        switch (this.definition.attributeType()) {
            case B: {
                return DBPDataKind.BINARY;
            }
            case N: {
                return DBPDataKind.NUMERIC;
            }
            case S: {
                return DBPDataKind.STRING;
            }
        }
        return DBPDataKind.OBJECT;
    }

    public Integer getScale() {
        return null;
    }

    public Integer getPrecision() {
        return null;
    }

    public long getMaxLength() {
        return 0L;
    }
}

