/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import com.dbeaver.ee.model.document.DBMapValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoDBUtils {
    public static Object getRawAttributeValue(@NotNull DynamoDataSource dataSource, DBSAttributeBase attribute, AttributeValue value) {
        if (attribute instanceof DynamoTableAttribute) {
            switch (((DynamoTableAttribute)attribute).getDefinition().attributeType()) {
                case B: {
                    return value.bool();
                }
                case S: {
                    return value.s();
                }
                case N: {
                    return DynamoDBUtils.getRawNumber(value.n());
                }
            }
            return value.s();
        }
        if (value.nul() != null) {
            return null;
        }
        if (value.bool() != null) {
            return value.bool();
        }
        if (value.n() != null) {
            return DynamoDBUtils.getRawNumber(value.n());
        }
        if (value.b() != null) {
            return value.b();
        }
        if (!CommonUtils.isEmpty((Map)value.m())) {
            return DynamoDBUtils.makeRawMap(dataSource, null, value.m());
        }
        if (!CommonUtils.isEmpty((Collection)value.l())) {
            return DynamoDBUtils.makeRawList(dataSource, value.l());
        }
        if (!CommonUtils.isEmpty((Collection)value.ss())) {
            return value.ss();
        }
        if (!CommonUtils.isEmpty((Collection)value.ns())) {
            ArrayList<Number> numList = new ArrayList<Number>();
            for (String n : value.ns()) {
                numList.add(DynamoDBUtils.getRawNumber(n));
            }
            return numList;
        }
        if (!CommonUtils.isEmpty((Collection)value.bs())) {
            return value.bs();
        }
        return value.s();
    }

    public static JsonElement getJsonAttributeValue(AttributeValue value) {
        if (value.nul() != null) {
            return null;
        }
        if (!CommonUtils.isEmpty((String)value.n())) {
            return DynamoDBUtils.getJsonNumber(value.n());
        }
        if (value.bool() != null) {
            return new JsonPrimitive(value.bool());
        }
        if (!CommonUtils.isEmpty((Map)value.m())) {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry ae : value.m().entrySet()) {
                jsonObject.add((String)ae.getKey(), DynamoDBUtils.getJsonAttributeValue((AttributeValue)ae.getValue()));
            }
            return jsonObject;
        }
        if (!CommonUtils.isEmpty((Collection)value.l())) {
            JsonArray jsonArray = new JsonArray();
            for (AttributeValue av : value.l()) {
                jsonArray.add(DynamoDBUtils.getJsonAttributeValue(av));
            }
            return jsonArray;
        }
        if (!CommonUtils.isEmpty((Collection)value.ss())) {
            JsonArray jsonArray = new JsonArray();
            for (String av : value.ss()) {
                jsonArray.add(av);
            }
            return jsonArray;
        }
        if (!CommonUtils.isEmpty((Collection)value.ns())) {
            JsonArray jsonArray = new JsonArray();
            for (String av : value.ns()) {
                jsonArray.add(DynamoDBUtils.getJsonNumber(av));
            }
            return jsonArray;
        }
        if (value.b() != null) {
            return new JsonPrimitive(value.b().toString());
        }
        if (!CommonUtils.isEmpty((Collection)value.bs())) {
            JsonArray jsonArray = new JsonArray();
            for (SdkBytes av : value.bs()) {
                jsonArray.add(av.toString());
            }
            return jsonArray;
        }
        return new JsonPrimitive(value.s());
    }

    public static Number getRawNumber(@Nullable String numString) {
        if (CommonUtils.isEmpty((String)numString)) {
            return null;
        }
        if (numString.indexOf(46) != -1) {
            return Double.parseDouble(numString);
        }
        return Long.parseLong(numString);
    }

    public static JsonElement getJsonNumber(String numString) {
        Number rawNumber = DynamoDBUtils.getRawNumber(numString);
        return rawNumber == null ? null : new JsonPrimitive(rawNumber);
    }

    private static List<Object> makeRawList(@NotNull DynamoDataSource dataSource, List<AttributeValue> list) {
        ArrayList<Object> rawList = new ArrayList<Object>();
        for (AttributeValue av : list) {
            rawList.add(DynamoDBUtils.getRawAttributeValue(dataSource, null, av));
        }
        return rawList;
    }

    public static DBMapValue<DynamoDataSource> makeRawMap(@NotNull DynamoDataSource dataSource, DynamoTable table, Map<String, AttributeValue> item) {
        LinkedHashMap<String, Object> rawMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
            DynamoTableAttribute attr = table == null ? null : table.getAttribute(null, entry.getKey());
            rawMap.put(entry.getKey(), DynamoDBUtils.getRawAttributeValue(dataSource, (DBSAttributeBase)attr, entry.getValue()));
        }
        return new DBMapValue((DBPDataSource)dataSource, rawMap);
    }

    public static AttributeValue getAttributeValue(Object value) {
        AttributeValue.Builder builder = AttributeValue.builder();
        if (value instanceof String) {
            builder.s((String)value);
        } else if (value instanceof Number) {
            builder.n(value.toString());
        } else if (value instanceof Collection) {
            String[] strings = new String[((Collection)value).size()];
            int index = 0;
            for (Object item : (Collection)value) {
                strings[index++] = CommonUtils.toString(item);
            }
            builder.ss(strings);
        } else {
            builder.nul(Boolean.valueOf(true));
        }
        return (AttributeValue)builder.build();
    }
}

