/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.dbeaver.ee.cassandra.CasUtils;
import com.dbeaver.ee.cassandra.exec.CasPreparedStatement;
import com.dbeaver.ee.cassandra.exec.CasResultSet;
import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.exec.CasSimpleStatement;
import com.dbeaver.ee.cassandra.model.CasCQLObject;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasKeyspace;
import com.dbeaver.ee.cassandra.model.CasPrivilegeGrant;
import com.dbeaver.ee.cassandra.model.CasTableColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.utils.ArrayUtils;

public abstract class CasTableBase
implements DBSTable,
DBSDataContainer,
DBSDataManipulator,
CasCQLObject {
    private static final Log log = Log.getLog(CasTableBase.class);
    private final CasKeyspace keyspace;
    private final ColumnCache columnCache = new ColumnCache();
    private List<CasPrivilegeGrant> privilegeGrants;

    protected CasTableBase(CasKeyspace keyspace) {
        this.keyspace = keyspace;
    }

    @Property(viewable=true, order=2)
    public CasKeyspace getKeyspace() {
        return this.keyspace;
    }

    public CasKeyspace getParentObject() {
        return this.keyspace;
    }

    @NotNull
    public CasDataSource getDataSource() {
        return this.keyspace.getDataSource();
    }

    public List<CasTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.columnCache.getAllObjects(monitor, this);
    }

    public CasTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return this.columnCache.getObject(monitor, this, attributeName);
    }

    public Collection<? extends DBSTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Association
    public List<CasPrivilegeGrant> getPrivilegeGrants(DBRProgressMonitor monitor) throws DBCException {
        if (this.privilegeGrants == null) {
            this.privilegeGrants = CasUtils.readPermissions(monitor, this.getDataSource(), "LIST ALL ON " + this.getFullyQualifiedName(DBPEvaluationContext.DML));
        }
        return this.privilegeGrants;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.keyspace, this});
    }

    public int getSupportedFeatures() {
        return 458757;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        try {
            DBCStatistics statistics;
            block27: {
                CasSession casSession = (CasSession)session;
                statistics = new DBCStatistics();
                String cql = "SELECT * FROM " + this.getFullyQualifiedName(DBPEvaluationContext.DML);
                cql = CasUtils.transformCQL(this.getDataSource(), cql, dataFilter);
                if (maxRows > 0L) {
                    cql = String.valueOf(cql) + " LIMIT " + (maxRows + (firstRow < 0L ? 0L : firstRow));
                }
                if (dataFilter != null && dataFilter.hasFilters()) {
                    cql = String.valueOf(cql) + " ALLOW FILTERING";
                }
                Throwable throwable = null;
                Object var16_15 = null;
                try (CasSimpleStatement statement = new CasSimpleStatement(casSession, cql);){
                    statement.setStatementSource(source);
                    statement.setLimit(firstRow, maxRows);
                    statistics.setQueryText(statement.getQueryString());
                    statistics.addStatementsCount();
                    if (!statement.executeStatement()) break block27;
                    Throwable throwable2 = null;
                    Object var19_20 = null;
                    try (CasResultSet resultSet = statement.openResultSet();){
                        dataReceiver.fetchStart((DBCSession)casSession, (DBCResultSet)resultSet, firstRow, maxRows);
                        try {
                            while (resultSet.nextRow()) {
                                if (session.getProgressMonitor().isCanceled()) {
                                    break;
                                }
                                dataReceiver.fetchRow((DBCSession)casSession, (DBCResultSet)resultSet);
                            }
                        }
                        finally {
                            dataReceiver.fetchEnd((DBCSession)casSession, (DBCResultSet)resultSet);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            return statistics;
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    /*
     * Exception decompiling
     */
    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        try {
            return new ExecuteBatchImpl(attributes, keysReceiver, true){

                @NotNull
                protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues) throws DBCException {
                    CasSession casSession = (CasSession)session;
                    StringBuilder cql = new StringBuilder();
                    cql.append("INSERT INTO ").append(CasTableBase.this.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" (");
                    int i = 0;
                    while (i < this.attributes.length) {
                        if (i > 0) {
                            cql.append(",");
                        }
                        cql.append(CasTableBase.this.getAttributeName(this.attributes[i]));
                        ++i;
                    }
                    cql.append(") VALUES (");
                    i = 0;
                    while (i < this.attributes.length) {
                        if (i > 0) {
                            cql.append(',');
                        }
                        cql.append('?');
                        ++i;
                    }
                    cql.append(")");
                    PreparedStatement preparedStatement = casSession.getImpl().prepare(cql.toString());
                    CasPreparedStatement statement = new CasPreparedStatement(casSession, preparedStatement);
                    statement.setStatementSource(source);
                    return statement;
                }

                protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                    int k = 0;
                    while (k < handlers.length) {
                        handlers[k].bindValueObject(statement.getSession(), statement, (DBSTypedObject)this.attributes[k], k, attributeValues[k]);
                        ++k;
                    }
                }
            };
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        try {
            DBSAttributeBase[] attributes = (DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes);
            return new ExecuteBatchImpl(attributes, keysReceiver, true){

                @NotNull
                protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues) throws DBCException {
                    CasSession casSession = (CasSession)session;
                    StringBuilder cql = new StringBuilder();
                    cql.append("UPDATE ").append(CasTableBase.this.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" SET ");
                    int i = 0;
                    while (i < updateAttributes.length) {
                        if (i > 0) {
                            cql.append(",");
                        }
                        cql.append(CasTableBase.this.getAttributeName(updateAttributes[i])).append("=?");
                        ++i;
                    }
                    if (keyAttributes.length > 0) {
                        cql.append(" WHERE ");
                        i = 0;
                        while (i < keyAttributes.length) {
                            if (i > 0) {
                                cql.append(" AND ");
                            }
                            cql.append(CasTableBase.this.getAttributeName(keyAttributes[i])).append("=?");
                            ++i;
                        }
                    }
                    PreparedStatement preparedStatement = casSession.getImpl().prepare(cql.toString());
                    CasPreparedStatement statement = new CasPreparedStatement(casSession, preparedStatement);
                    statement.setStatementSource(source);
                    return statement;
                }

                protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                    int k = 0;
                    while (k < handlers.length) {
                        handlers[k].bindValueObject(statement.getSession(), statement, (DBSTypedObject)this.attributes[k], k, attributeValues[k]);
                        ++k;
                    }
                }
            };
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] keyAttributes, final @NotNull DBCExecutionSource source) throws DBCException {
        try {
            return new ExecuteBatchImpl(keyAttributes, null, true){

                @NotNull
                protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues) throws DBCException {
                    CasSession casSession = (CasSession)session;
                    StringBuilder cql = new StringBuilder();
                    cql.append("DELETE FROM ").append(CasTableBase.this.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" WHERE ");
                    int i = 0;
                    while (i < keyAttributes.length) {
                        if (i > 0) {
                            cql.append(" AND ");
                        }
                        cql.append(CasTableBase.this.getAttributeName(keyAttributes[i])).append("=?");
                        ++i;
                    }
                    PreparedStatement preparedStatement = casSession.getImpl().prepare(cql.toString());
                    CasPreparedStatement statement = new CasPreparedStatement(casSession, preparedStatement);
                    statement.setStatementSource(source);
                    return statement;
                }

                protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                    int k = 0;
                    while (k < handlers.length) {
                        handlers[k].bindValueObject(statement.getSession(), statement, (DBSTypedObject)this.attributes[k], k, attributeValues[k]);
                        ++k;
                    }
                }
            };
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    public DBCStatistics truncateData(DBCSession session, DBCExecutionSource source) throws DBCException {
        DBCStatistics statistics = new DBCStatistics();
        String cql = "TRUNCATE " + this.getFullyQualifiedName(DBPEvaluationContext.DML);
        ((CasSession)session).getImpl().execute(cql);
        statistics.addStatementsCount();
        statistics.addExecuteTime();
        return statistics;
    }

    private String getAttributeName(DBSAttributeBase attribute) {
        return DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)attribute.getName());
    }

    protected abstract List<ColumnMetadata> getMetaColumns();

    class ColumnCache
    extends AbstractObjectCache<CasTableBase, CasTableColumn> {
        ColumnCache() {
        }

        @NotNull
        public List<CasTableColumn> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasTableBase table) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasTableColumn> columns = new ArrayList<CasTableColumn>();
                List<ColumnMetadata> mdcs = CasTableBase.this.getMetaColumns();
                int i = 0;
                while (i < mdcs.size()) {
                    ColumnMetadata tmd = mdcs.get(i);
                    columns.add(new CasTableColumn(table, tmd, i));
                    if (monitor.isCanceled()) break;
                    ++i;
                }
                this.setCache(columns);
            }
            return this.getCachedObjects();
        }

        public CasTableColumn getObject(@NotNull DBRProgressMonitor monitor, @Nullable CasTableBase casKeyspace, @NotNull String name) throws DBException {
            return (CasTableColumn)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }
}

