/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.views;

import com.dbeaver.ee.cassandra.CasMessages;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class CasSocketSettingsPage
extends ConnectionPageAbstract {
    private Spinner connectTimeoutSpinner;
    private Spinner readTimeoutSpinner;
    private Button keepAliveButton;
    private Button reuseAddressButton;
    private Spinner receiveBufferSizeSpinner;
    private Spinner sendBufferSizeSpinner;
    private Spinner soLingerSpinner;
    private Button tcpNoDelayButton;

    public CasSocketSettingsPage() {
        this.setTitle(CasMessages.settings_page_title_cas_tcp_settings);
        this.setDescription(CasMessages.settings_page_title_description);
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite cfgGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        cfgGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        cfgGroup.setLayoutData((Object)gd);
        UIUtils.createLink((Composite)cfgGroup, (String)(String.valueOf(CasMessages.settings_page_text_tcp_settings_controls) + CasMessages.settings_page_link_online_documentation), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)"https://docs.datastax.com/en/developer/java-driver/3.1/manual/socket_options/");
            }
        });
        Group timeoutsGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)CasMessages.settings_page_group_timeouts, (int)2, (int)0, (int)0);
        timeoutsGroup.setLayoutData((Object)new GridData(768));
        this.connectTimeoutSpinner = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)CasMessages.settings_page_label_spinner_connect_timeout, (String)CasMessages.settings_page_label_spinner_tip_connect_timeout, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.readTimeoutSpinner = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)CasMessages.settings_page_label_spinner_read_timeout, (String)CasMessages.settings_page_label_spinner_tip_read_timeout, (int)0, (int)0, (int)Integer.MAX_VALUE);
        Group tcpGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)"TCP/IP", (int)2, (int)0, (int)0);
        tcpGroup.setLayoutData((Object)new GridData(768));
        this.keepAliveButton = UIUtils.createCheckbox((Composite)tcpGroup, (String)CasMessages.settings_page_checkbox_keep_alive, (String)CasMessages.settings_page_checkbox_tip_keep_whether_tcp, (boolean)false, (int)2);
        this.reuseAddressButton = UIUtils.createCheckbox((Composite)tcpGroup, (String)CasMessages.settings_page_checkbox_reuse_address, (String)CasMessages.settings_page_checkbox_tip_wether_reuse_address, (boolean)false, (int)2);
        this.receiveBufferSizeSpinner = UIUtils.createLabelSpinner((Composite)tcpGroup, (String)CasMessages.settings_page_label_spinner_receive_buffer_size, (String)CasMessages.settings_page_label_spinner_tip_receive_buffer_size, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.sendBufferSizeSpinner = UIUtils.createLabelSpinner((Composite)tcpGroup, (String)CasMessages.settings_page_label_spinner_send_buffer_size, (String)CasMessages.settings_page_label_spinner_tip_send_buffer_size, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.soLingerSpinner = UIUtils.createLabelSpinner((Composite)tcpGroup, (String)CasMessages.settings_page_label_spinner_solinger, (String)CasMessages.settings_page_label_spinner_tip_solinger, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.tcpNoDelayButton = UIUtils.createCheckbox((Composite)tcpGroup, (String)CasMessages.settings_page_checkbox_tcp_no_delay, (String)CasMessages.settings_page_checkbox_tip_tcp_no_delay, (boolean)false, (int)2);
        this.setControl((Control)cfgGroup);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        Map providerProperties = connectionInfo.getProviderProperties();
        this.connectTimeoutSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.timeout.connect@"), (int)0));
        this.readTimeoutSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.timeout.read@"), (int)0));
        this.keepAliveButton.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-cas.net.keepAlive@")), (boolean)false));
        this.reuseAddressButton.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-cas.net.reuseAddr@")), (boolean)false));
        this.receiveBufferSizeSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.net.receiveBufferSize@"), (int)0));
        this.sendBufferSizeSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.net.sendBufferSize@"), (int)0));
        this.soLingerSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.net.soLinger@"), (int)0));
        this.tcpNoDelayButton.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-cas.net.soLinger@")), (boolean)false));
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        Map providerProperties = dataSource.getConnectionConfiguration().getProviderProperties();
        if (this.connectTimeoutSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.timeout.connect@", String.valueOf(this.connectTimeoutSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.timeout.connect@");
        }
        if (this.readTimeoutSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.timeout.read@", String.valueOf(this.readTimeoutSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.timeout.read@");
        }
        if (this.keepAliveButton.getSelection()) {
            providerProperties.put("@dbeaver-cas.net.keepAlive@", String.valueOf(this.keepAliveButton.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.keepAlive@");
        }
        if (this.reuseAddressButton.getSelection()) {
            providerProperties.put("@dbeaver-cas.net.reuseAddr@", String.valueOf(this.reuseAddressButton.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.reuseAddr@");
        }
        if (this.receiveBufferSizeSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.net.receiveBufferSize@", String.valueOf(this.receiveBufferSizeSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.receiveBufferSize@");
        }
        if (this.sendBufferSizeSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.net.sendBufferSize@", String.valueOf(this.sendBufferSizeSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.sendBufferSize@");
        }
        if (this.soLingerSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.net.soLinger@", String.valueOf(this.soLingerSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.soLinger@");
        }
        if (this.tcpNoDelayButton.getSelection()) {
            providerProperties.put("@dbeaver-cas.net.tcpNoDelay@", String.valueOf(this.tcpNoDelayButton.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.tcpNoDelay@");
        }
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
    }
}

