/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.model;

import com.dbeaver.ee.qmdb.model.QMDBModel;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMEventBrowser;
import org.jkiss.dbeaver.model.qm.QMEventCriteria;
import org.jkiss.dbeaver.model.qm.QMEventCursor;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMObjectType;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.LongKeyMap;

public class QMDBEventBrowser
implements QMEventBrowser {
    private static final Log log = Log.getLog(QMDBEventBrowser.class);
    private final QMDBModel model;
    private final Map<String, DataSourceInfo> dataSourceCache = new HashMap<String, DataSourceInfo>();
    private final LongKeyMap<QMMSessionInfo> sessionCache = new LongKeyMap();

    public QMDBEventBrowser(QMDBModel model) {
        this.model = model;
    }

    public QMEventCursor getQueryHistoryCursor(@NotNull DBRProgressMonitor monitor, @NotNull QMEventCriteria criteria, QMEventFilter filter) throws DBException {
        try {
            return new QMDBEventCursor(criteria, filter);
        }
        catch (SQLException e) {
            throw new DBException("Error getting filter history", (Throwable)e);
        }
    }

    private QMMSessionInfo getSessionInfo(long sessionId, String containerId, String contextName, long eventStart) throws DBException {
        QMMSessionInfo sessionInfo = (QMMSessionInfo)this.sessionCache.get(sessionId);
        if (sessionInfo == null) {
            DataSourceInfo dataSourceInfo = this.getDataSourceInfo(containerId);
            DBPConnectionConfiguration config = new DBPConnectionConfiguration();
            config.setUrl(dataSourceInfo.url);
            sessionInfo = new QMMSessionInfo(eventStart, eventStart, containerId, dataSourceInfo.name, dataSourceInfo.driverID, config, contextName, false);
            this.sessionCache.put(sessionId, (Object)sessionInfo);
        }
        return sessionInfo;
    }

    private synchronized DataSourceInfo getDataSourceInfo(String containerId) throws DBException {
        DataSourceInfo dataSourceInfo = this.dataSourceCache.get(containerId);
        if (dataSourceInfo == null) {
            dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.containerID = containerId;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (PreparedStatement stmt = this.model.getConnection().prepareStatement("SELECT * FROM QM_DATASOURCE WHERE DATASOURCE_ID=?");){
                    stmt.setString(1, containerId);
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (ResultSet dbResult = stmt.executeQuery();){
                        if (dbResult.next()) {
                            dataSourceInfo.name = dbResult.getString("NAME");
                            dataSourceInfo.url = dbResult.getString("URL");
                            dataSourceInfo.driverID = dbResult.getString("DRIVER");
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Error reading datasource info", (Throwable)e);
            }
            this.dataSourceCache.put(containerId, dataSourceInfo);
        }
        return dataSourceInfo;
    }

    private static class DataSourceInfo {
        String containerID;
        String driverID;
        String name;
        String url;

        private DataSourceInfo() {
        }
    }

    private class QMDBEventCursor
    implements QMEventCursor {
        public static final int EVENTS_MAX_SIZE = 2000;
        private final Statement eventStat;
        private final ResultSet eventResults;
        private QMMetaEvent nextEvent;
        private Boolean hasNext;
        private QMEventFilter filter;

        public QMDBEventCursor(QMEventCriteria criteria, QMEventFilter filter) throws SQLException {
            this.filter = filter;
            log.debug((Object)"Reading event history from QMDB");
            this.eventStat = QMDBEventBrowser.this.model.getConnection().createStatement(1003, 1007);
            try {
                this.eventStat.setFetchSize(200);
                this.eventStat.setMaxRows(2000);
                String searchString = criteria.getSearchString();
                if (!CommonUtils.isEmpty((String)searchString)) {
                    searchString = searchString.replace("'", "''").toLowerCase();
                    log.debug((Object)("Search for events '" + searchString + "'"));
                }
                StringBuilder eventFilterWhere = new StringBuilder();
                StringBuilder statementFilterWhere = new StringBuilder();
                if (criteria.hasObjectTypes() || criteria.hasQueryTypes()) {
                    int i;
                    if (criteria.hasObjectTypes()) {
                        ArrayList<Integer> typeIds = new ArrayList<Integer>();
                        if (criteria.hasObjectType(QMObjectType.session)) {
                            typeIds.add(1);
                        }
                        if (criteria.hasObjectType(QMObjectType.txn)) {
                            typeIds.add(2);
                            typeIds.add(3);
                        }
                        if (criteria.hasObjectType(QMObjectType.query)) {
                            typeIds.add(4);
                            typeIds.add(5);
                        }
                        eventFilterWhere.append("EVENT_TYPE IN (");
                        i = 0;
                        while (i < typeIds.size()) {
                            if (i > 0) {
                                eventFilterWhere.append(",");
                            }
                            eventFilterWhere.append(typeIds.get(i));
                            ++i;
                        }
                        eventFilterWhere.append(")");
                    }
                    if (criteria.hasQueryTypes()) {
                        statementFilterWhere.append(" AND STATEMENT_PURPOSE IN (");
                        DBCExecutionPurpose[] queryTypes = criteria.getQueryTypes();
                        i = 0;
                        while (i < queryTypes.length) {
                            DBCExecutionPurpose p = queryTypes[i];
                            if (i > 0) {
                                statementFilterWhere.append(",");
                            }
                            statementFilterWhere.append(p.getId());
                            ++i;
                        }
                        statementFilterWhere.append(")");
                    }
                }
                if (eventFilterWhere.length() == 0) {
                    eventFilterWhere.append("(EVENT_ACTION = 1 OR EVENT_TYPE = 1)");
                }
                String sql = CommonUtils.isEmpty((String)searchString) ? "SELECT \ne.CONNECTION_ID,e.EVENT_ACTION,e.EVENT_TYPE,e.EVENT_TIME,\nc.DATASOURCE_ID,c.CONTEXT_NAME,\ns.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,\nq.QUERY_TEXT \nFROM QM_EVENT e\nLEFT JOIN QM_CONNECTION c ON c.CONNECTION_ID = e.CONNECTION_ID \nLEFT OUTER JOIN QM_STATEMENT s ON s.STATEMENT_ID = e.EVENT_ID\nLEFT OUTER JOIN QM_QUERY q ON q.QUERY_ID = s.QUERY_ID\nWHERE " + eventFilterWhere + statementFilterWhere + "\n" + "ORDER BY e.EVENT_ID DESC" : "SELECT * FROM (\nSELECT \ne.CONNECTION_ID,e.EVENT_ACTION,EVENT_TYPE,e.EVENT_TIME,\nc.DATASOURCE_ID,c.CONTEXT_NAME,\ns.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,\nq.QUERY_TEXT \nFROM QM_QUERY q\nJOIN QM_STATEMENT s ON s.QUERY_ID = q.QUERY_ID\nJOIN QM_EVENT e ON e.EVENT_ID = s.STATEMENT_ID \nJOIN QM_CONNECTION c ON c.CONNECTION_ID = e.CONNECTION_ID\nWHERE lower(q.QUERY_TEXT) LIKE '%" + searchString + "%'\n" + "ORDER BY e.EVENT_ID DESC\n" + ") WHERE " + eventFilterWhere + statementFilterWhere;
                this.eventResults = this.eventStat.executeQuery(sql);
            }
            catch (SQLException e) {
                this.eventStat.close();
                throw e;
            }
        }

        public long getTotalSize() {
            return -1L;
        }

        public void scroll(int position, DBRProgressMonitor monitor) throws DBException {
            try {
                this.eventResults.absolute(position + 1);
            }
            catch (SQLException e) {
                throw new DBException("Error scrolling cursor", (Throwable)e);
            }
        }

        public boolean hasNextEvent(DBRProgressMonitor monitor) throws DBException {
            this.fetchNext(monitor);
            return this.hasNext != null && this.hasNext != false;
        }

        public QMMetaEvent nextEvent(DBRProgressMonitor monitor) throws DBException {
            try {
                if (this.nextEvent != null) {
                    QMMetaEvent qMMetaEvent = this.nextEvent;
                    return qMMetaEvent;
                }
                this.fetchNext(monitor);
                QMMetaEvent qMMetaEvent = this.nextEvent;
                return qMMetaEvent;
            }
            finally {
                this.hasNext = null;
                this.nextEvent = null;
            }
        }

        private void fetchNext(DBRProgressMonitor monitor) throws DBException {
            if (this.nextEvent != null || this.hasNext != null) {
                return;
            }
            do {
                QMMSessionInfo object;
                try {
                    this.hasNext = this.eventResults.next();
                }
                catch (SQLException e) {
                    throw new DBException("Error fetching cursor", (Throwable)e);
                }
                if (!this.hasNext.booleanValue()) {
                    return;
                }
                long sessionId = JDBCUtils.safeGetLong((ResultSet)this.eventResults, (int)1);
                int eventAction = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)2);
                int eventType = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)3);
                Timestamp eventTime = JDBCUtils.safeGetTimestamp((ResultSet)this.eventResults, (int)4);
                String containerId = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)5);
                String contextName = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)6);
                int statementPurpose = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)7);
                long rowCount = JDBCUtils.safeGetLong((ResultSet)this.eventResults, (int)8);
                int errorCode = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)9);
                String errorMessage = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)10);
                int execTime = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)11);
                int fetchTime = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)12);
                String queryText = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)13);
                long eventStart = eventTime == null ? 0L : ((Date)eventTime).getTime();
                QMMSessionInfo sessionInfo = QMDBEventBrowser.this.getSessionInfo(sessionId, containerId, contextName, eventStart);
                if (eventType == 1) {
                    object = sessionInfo;
                } else {
                    QMMStatementInfo stmt = new QMMStatementInfo(eventStart, eventStart + (long)execTime, sessionInfo, DBCExecutionPurpose.getById((int)statementPurpose));
                    object = new QMMStatementExecuteInfo(eventStart, eventStart + (long)execTime, stmt, queryText, rowCount, errorCode, errorMessage, eventStart, eventStart + (long)fetchTime, false);
                }
                this.nextEvent = new QMMetaEvent((QMMObject)object, QMMetaEvent.Action.getById((int)eventAction));
            } while (this.filter != null && !this.filter.accept(this.nextEvent));
        }

        public void close() {
            if (this.eventResults != null) {
                IOUtils.close((AutoCloseable)this.eventResults);
            }
            if (this.eventStat != null) {
                IOUtils.close((AutoCloseable)this.eventStat);
            }
        }
    }
}

