/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.enableconstraint;

import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.check.CheckAttribute;
import liquibase.ext.ora.disableconstraint.DisableConstraintChange;
import liquibase.ext.ora.enableconstraint.EnableConstraintStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="enableConstraint", description="Enable constraint", priority=1)
public class EnableConstraintChange
extends CheckAttribute {
    @Override
    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        EnableConstraintStatement statement = new EnableConstraintStatement(this.getTableName(), schemaName, this.getConstraintName());
        statement.setTablespace(this.getTablespace());
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return "Constraint " + this.getConstraintName() + " ENABLED in " + this.getTableName();
    }

    protected Change[] createInverses() {
        DisableConstraintChange inverse = new DisableConstraintChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }
}

