/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManagerBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class PostgreViewManager
extends PostgreTableManagerBase
implements DBEObjectRenamer<PostgreTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{PostgreTableColumn.class};

    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreSchema)object.getContainer()).tableCache;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        PostgreTableBase object = (PostgreTableBase)command.getObject();
        if (CommonUtils.isEmpty((String)object.getName())) {
            throw new DBException("View name cannot be empty");
        }
    }

    protected PostgreViewBase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, PostgreSchema parent, Object copyFrom) {
        PostgreView newView = new PostgreView(parent);
        try {
            newView.setName(this.getNewChildName(monitor, (DBSObjectContainer)parent, "new_view"));
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return newView;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        this.createOrReplaceViewQuery(monitor, actions, (PostgreViewBase)command.getObject());
        this.addObjectExtraActions(monitor, actions, (SQLObjectEditor.NestedObjectCommand<PostgreTableBase, SQLObjectEditor.PropertyHandler>)command, options);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        this.createOrReplaceViewQuery(monitor, actionList, (PostgreViewBase)command.getObject());
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        PostgreViewBase view = (PostgreViewBase)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP " + view.getViewType() + " " + view.getFullyQualifiedName(DBPEvaluationContext.DDL) + (CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }

    protected void createOrReplaceViewQuery(DBRProgressMonitor monitor, List<DBEPersistAction> actions, PostgreViewBase view) throws DBException {
        if (!CommonUtils.isEmpty((String)view.getSource())) {
            String sql = view.getSource().trim();
            if (!sql.toLowerCase(Locale.ENGLISH).startsWith("create")) {
                StringBuilder sqlBuf = new StringBuilder();
                sqlBuf.append("CREATE ");
                if (!(view instanceof PostgreMaterializedView)) {
                    sqlBuf.append("OR REPLACE ");
                }
                sqlBuf.append(view.getViewType()).append(" ").append(DBUtils.getObjectFullName((DBPNamedObject)view, (DBPEvaluationContext)DBPEvaluationContext.DDL));
                this.appendViewDeclarationPrefix(monitor, sqlBuf, view);
                sqlBuf.append("\nAS ").append(sql);
                this.appendViewDeclarationPostfix(monitor, sqlBuf, view);
                sql = sqlBuf.toString();
            }
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", sql));
        }
    }

    public void appendViewDeclarationPrefix(DBRProgressMonitor monitor, StringBuilder sqlBuf, PostgreViewBase view) throws DBException {
    }

    public void appendViewDeclarationPostfix(DBRProgressMonitor monitor, StringBuilder sqlBuf, PostgreViewBase view) {
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableBase object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreTableBase view = (PostgreTableBase)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename view", "ALTER VIEW " + DBUtils.getQuotedIdentifier((DBSObject)view.getSchema()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)view.getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)view.getDataSource(), (String)command.getNewName())));
    }
}

