/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiFunction;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import javax.annotation.Nullable;

public final class BigtableTableAdminSettings {
    private final String projectId;
    private final String instanceId;
    private final BigtableTableAdminStubSettings stubSettings;

    private BigtableTableAdminSettings(Builder builder) throws IOException {
        this.projectId = (String)Preconditions.checkNotNull((Object)builder.projectId, (Object)"Project ID must be set");
        this.instanceId = (String)Preconditions.checkNotNull((Object)builder.instanceId, (Object)"Instance ID must be set");
        this.stubSettings = ((BigtableTableAdminStubSettings.Builder)((Object)Verify.verifyNotNull((Object)((Object)builder.stubSettings), (String)"stubSettings should never be null", (Object[])new Object[0]))).build();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.stubSettings.getCredentialsProvider();
    }

    public BigtableTableAdminStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderForEmulator(int port) {
        Builder builder = BigtableTableAdminSettings.newBuilder().setProjectId("fake-project").setInstanceId("fake-instance");
        ((BigtableTableAdminStubSettings.Builder)((BigtableTableAdminStubSettings.Builder)builder.stubSettings().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setEndpoint("localhost:" + port)).setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setPoolSize(1).setChannelConfigurator((ApiFunction)new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            public ManagedChannelBuilder apply(ManagedChannelBuilder input) {
                return input.usePlaintext();
            }
        }).build());
        return builder;
    }

    public static final class Builder {
        @Nullable
        private String projectId;
        @Nullable
        private String instanceId;
        private final BigtableTableAdminStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = BigtableTableAdminStubSettings.newBuilder();
        }

        private Builder(BigtableTableAdminSettings settings) {
            this.projectId = settings.projectId;
            this.instanceId = settings.instanceId;
            this.stubSettings = settings.stubSettings.toBuilder();
        }

        public Builder setProjectId(@Nullable String projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        @Nullable
        public String getProjectId() {
            return this.projectId;
        }

        public Builder setInstanceId(@Nullable String instanceId) {
            Preconditions.checkNotNull((Object)instanceId);
            this.instanceId = instanceId;
            return this;
        }

        @Nullable
        public String getInstanceId() {
            return this.instanceId;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.stubSettings.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.stubSettings.getCredentialsProvider();
        }

        public BigtableTableAdminStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableTableAdminSettings build() throws IOException {
            return new BigtableTableAdminSettings(this);
        }
    }
}

