/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.model.document;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.struct.AbstractDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.utils.CommonUtils;

public class DBMapValue<DATASOURCE extends DBPDataSource>
extends AbstractDataType<DATASOURCE>
implements DBDComposite,
DBDValueCloneable {
    public static Gson JSON_BUILDER = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").serializeNulls().create();
    @Nullable
    private Map<String, Object> contents;
    private boolean modified;

    public DBMapValue(@NotNull DATASOURCE dataSource, @Nullable Map<String, Object> sourceData) {
        super(dataSource);
        this.contents = sourceData;
    }

    public DBMapValue(@NotNull DBMapValue<DATASOURCE> source) {
        super(source.getDataSource());
        this.contents = new LinkedHashMap<String, Object>(source.contents);
    }

    public Map<String, Object> getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    @NotNull
    public String getTypeName() {
        return "DBObject";
    }

    public int getTypeID() {
        return 0;
    }

    public DBPDataKind getDataKind() {
        return DBPDataKind.STRUCT;
    }

    public DBSDataType getDataType() {
        return this;
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        if (this.contents == null || this.contents.isEmpty()) {
            return new DBSAttributeBase[0];
        }
        Set<String> keySet = this.contents.keySet();
        DBSAttributeBase[] attrs = new DBSAttributeBase[keySet.size()];
        int index = 0;
        for (String key : keySet) {
            attrs[index++] = new MapAttribute(index, key, this.contents.get(key));
        }
        return attrs;
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        return this.contents.get(attribute.getName());
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) {
        if (this.contents != null) {
            this.contents.put(attribute.getName(), value);
        }
        this.modified = true;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new DBMapValue<DATASOURCE>(this);
    }

    public String toString() {
        return JSON_BUILDER.toJson(this.getRawValue());
    }

    private static MapValueType getMapValueTypeFromValue(Object value) {
        if (value == null) {
            return MapValueType.NULL;
        }
        if (value instanceof CharSequence) {
            return MapValueType.STRING;
        }
        if (value instanceof Number) {
            return MapValueType.NUMBER;
        }
        if (value instanceof Date || value instanceof Instant) {
            return MapValueType.DATETIME;
        }
        if (value instanceof Collection) {
            return MapValueType.ARRAY;
        }
        if (value instanceof Map) {
            return MapValueType.MAP;
        }
        return MapValueType.OBJECT;
    }

    private static class MapAttribute
    implements DBSAttributeBase {
        String name;
        int position;
        MapValueType valueType;

        MapAttribute(int index, String name, Object value) {
            this.position = index;
            this.name = name;
            this.valueType = DBMapValue.getMapValueTypeFromValue(value);
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.valueType.name();
        }

        public String getFullTypeName() {
            return this.getTypeName();
        }

        public int getTypeID() {
            return this.valueType.ordinal();
        }

        public DBPDataKind getDataKind() {
            return this.valueType.getDataKind();
        }

        public Integer getScale() {
            return null;
        }

        public Integer getPrecision() {
            return null;
        }

        public long getMaxLength() {
            return 0L;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapAttribute)) {
                return false;
            }
            MapAttribute attr = (MapAttribute)obj;
            return CommonUtils.equalObjects((Object)this.name, (Object)attr.name) && this.valueType == attr.valueType && this.position == attr.position;
        }

        public int hashCode() {
            return this.name.hashCode() + this.valueType.ordinal() + this.position;
        }

        public int getOrdinalPosition() {
            return this.position;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }
    }

    public static enum MapValueType {
        NULL(DBPDataKind.ANY),
        STRING(DBPDataKind.STRING),
        NUMBER(DBPDataKind.NUMERIC),
        BOOLEAN(DBPDataKind.BOOLEAN),
        DATETIME(DBPDataKind.DATETIME),
        ARRAY(DBPDataKind.ARRAY),
        MAP(DBPDataKind.STRUCT),
        OBJECT(DBPDataKind.OBJECT);

        private final DBPDataKind dataKind;

        private MapValueType(DBPDataKind dataKind) {
            this.dataKind = dataKind;
        }

        public DBPDataKind getDataKind() {
            return this.dataKind;
        }
    }
}

