/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc.logs;

import java.io.PrintStream;
import java.util.List;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hive.jdbc.logs.InPlaceUpdateStream;
import org.apache.hive.service.cli.thrift.TJobExecutionStatus;
import org.apache.hive.service.cli.thrift.TProgressUpdateResp;

public class BeelineInPlaceUpdateStream
implements InPlaceUpdateStream {
    private InPlaceUpdate inPlaceUpdate;
    private InPlaceUpdateStream.EventNotifier notifier;

    public BeelineInPlaceUpdateStream(PrintStream out, InPlaceUpdateStream.EventNotifier notifier) {
        this.inPlaceUpdate = new InPlaceUpdate(out);
        this.notifier = notifier;
    }

    @Override
    public void update(TProgressUpdateResp response) {
        if (response == null || response.getStatus().equals(TJobExecutionStatus.NOT_AVAILABLE)) {
            this.notifier.progressBarCompleted();
        } else if (this.notifier.isOperationLogUpdatedAtLeastOnce()) {
            this.inPlaceUpdate.render(new ProgressMonitorWrapper(response));
        }
    }

    @Override
    public InPlaceUpdateStream.EventNotifier getEventNotifier() {
        return this.notifier;
    }

    static class ProgressMonitorWrapper
    implements ProgressMonitor {
        private TProgressUpdateResp response;

        ProgressMonitorWrapper(TProgressUpdateResp response) {
            this.response = response;
        }

        @Override
        public List<String> headers() {
            return this.response.getHeaderNames();
        }

        @Override
        public List<List<String>> rows() {
            return this.response.getRows();
        }

        @Override
        public String footerSummary() {
            return this.response.getFooterSummary();
        }

        @Override
        public long startTime() {
            return this.response.getStartTime();
        }

        @Override
        public String executionStatus() {
            throw new UnsupportedOperationException("This should never be used for anything. All the required data is available via other methods");
        }

        @Override
        public double progressedPercentage() {
            return this.response.getProgressedPercentage();
        }
    }
}

