/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.maxdb.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.maxdb.database.MaxDBDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.RenameColumnGenerator;
import liquibase.statement.core.RenameColumnStatement;
import liquibase.structure.DatabaseObject;

public class RenameColumnGeneratorMaxDB
extends RenameColumnGenerator {
    public boolean supports(RenameColumnStatement statement, Database database) {
        return database instanceof MaxDBDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public Sql[] generateSql(RenameColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql = "RENAME COLUMN " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + "." + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getOldColumnName()) + " TO " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getNewColumnName());
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedOldColumn(statement), this.getAffectedNewColumn(statement)})};
    }
}

