/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.exec.DynamoResultSet;
import com.dbeaver.db.dynamodb.exec.DynamoScanStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexAbstract;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexGlobal;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexLocal;
import com.dbeaver.db.dynamodb.model.DynamoTableKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

public class DynamoTable
implements DBSTable,
DBPSaveableObject,
DBPSystemObject,
DBPRefreshableObject,
DBSDataContainer {
    private static final Log log = Log.getLog(DynamoTable.class);
    private final DynamoDataSource dataSource;
    private final String tableName;
    private boolean persisted;
    private volatile DynamoTableKey key;
    private volatile List<DynamoTableAttribute> attributes;
    private volatile List<DynamoTableIndexLocal> localIndexes;
    private volatile List<DynamoTableIndexGlobal> globalIndexes;
    private volatile TableDescription tableDescription;

    public DynamoTable(DynamoDataSource dataSource, String tableName) {
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.persisted = true;
    }

    @NotNull
    public DynamoDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.tableName;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return false;
    }

    @Property
    public TableStatus getTableStatus(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).tableStatus();
    }

    @Property
    public Instant getCreationDateTime(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).creationDateTime();
    }

    @Property
    public Long getTableSizeBytes(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).tableSizeBytes();
    }

    @Property
    public Long getRowCount(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).itemCount();
    }

    @Property
    public String getTableArn(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).tableArn();
    }

    @Property
    public String getTableId(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).tableId();
    }

    @Property
    public String getLatestStreamLabel(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).latestStreamLabel();
    }

    @Property
    public String getLatestStreamArn(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).latestStreamArn();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableDescription = null;
        this.localIndexes = null;
        this.globalIndexes = null;
        this.key = null;
        return this;
    }

    public boolean isView() {
        return false;
    }

    TableDescription getTableDescription(DBRProgressMonitor monitor) {
        if (this.tableDescription == null) {
            DescribeTableResponse dtResponse = this.dataSource.getClient().describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.tableName).build());
            this.tableDescription = dtResponse == null ? null : dtResponse.table();
        }
        return this.tableDescription;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public Collection<DynamoTableAttribute> getAttributes(DBRProgressMonitor monitor) {
        if (this.attributes == null) {
            ArrayList<DynamoTableAttribute> result = new ArrayList<DynamoTableAttribute>();
            for (AttributeDefinition attrDef : this.getTableDescription(monitor).attributeDefinitions()) {
                result.add(new DynamoTableAttribute(this, attrDef));
            }
            this.attributes = result;
        }
        return this.attributes;
    }

    public DynamoTableAttribute getAttribute(DBRProgressMonitor monitor, @NotNull String attributeName) {
        return (DynamoTableAttribute)DBUtils.findObject(this.getAttributes(monitor), (String)attributeName);
    }

    public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.singletonList(this.getKey(monitor));
    }

    public DynamoTableKey getKey(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.key == null) {
            this.key = new DynamoTableKey(monitor, this, this.getTableDescription(monitor).keySchema());
        }
        return this.key;
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<DynamoTableIndexAbstract> getIndexes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<DynamoTableIndexAbstract> allIndexes = new ArrayList<DynamoTableIndexAbstract>();
        allIndexes.addAll(this.getLocalIndexes(monitor));
        allIndexes.addAll(this.getGlobalIndexes(monitor));
        return allIndexes;
    }

    public List<DynamoTableIndexLocal> getLocalIndexes(DBRProgressMonitor monitor) throws DBException {
        if (this.localIndexes == null) {
            ArrayList<DynamoTableIndexLocal> tmp = new ArrayList<DynamoTableIndexLocal>();
            for (LocalSecondaryIndexDescription indexDef : this.getTableDescription(monitor).localSecondaryIndexes()) {
                tmp.add(new DynamoTableIndexLocal(monitor, this, indexDef));
            }
            this.localIndexes = tmp;
        }
        return this.localIndexes;
    }

    public List<DynamoTableIndexGlobal> getGlobalIndexes(DBRProgressMonitor monitor) throws DBException {
        if (this.globalIndexes == null) {
            ArrayList<DynamoTableIndexGlobal> tmp = new ArrayList<DynamoTableIndexGlobal>();
            for (GlobalSecondaryIndexDescription indexDef : this.getTableDescription(monitor).globalSecondaryIndexes()) {
                tmp.add(new DynamoTableIndexGlobal(monitor, this, indexDef));
            }
            this.globalIndexes = tmp;
        }
        return this.globalIndexes;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getQuotedIdentifier((DBSObject)this);
    }

    public int getSupportedFeatures() {
        return 1;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        DBCStatistics statistics = new DBCStatistics();
        long startTime = System.currentTimeMillis();
        DynamoScanStatement scanStatement = new DynamoScanStatement((DynamoSession)session, this);
        scanStatement.setLimit(firstRow, maxRows);
        scanStatement.executeStatement();
        DynamoResultSet resultSet = scanStatement.openResultSet();
        dataReceiver.fetchStart(session, (DBCResultSet)resultSet, firstRow, maxRows);
        try {
            while (resultSet.nextRow()) {
                dataReceiver.fetchRow(session, (DBCResultSet)resultSet);
            }
        }
        finally {
            dataReceiver.fetchEnd(session, (DBCResultSet)resultSet);
        }
        statistics.addExecuteTime(System.currentTimeMillis() - startTime);
        return statistics;
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, DBDDataFilter dataFilter, long flags) throws DBCException {
        return this.getRowCount(session.getProgressMonitor());
    }
}

