/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.exec.DynamoExecutionContext;
import com.dbeaver.db.dynamodb.exec.DynamoQueryStatement;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DynamoSession
extends AbstractSession {
    private static final Log log = Log.getLog(DynamoSession.class);
    private final DynamoExecutionContext executionContext;

    public DynamoSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle, DynamoExecutionContext executionContext) {
        super(monitor, purpose, taskTitle);
        this.executionContext = executionContext;
    }

    @NotNull
    public DynamoExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public DynamoDataSource getDataSource() {
        return (DynamoDataSource)this.executionContext.getDataSource();
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        return new DynamoQueryStatement(this, query);
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        throw new DBException("Dynamo session cancel not implemented");
    }

    public void close() {
        super.close();
    }
}

