/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.data;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import com.dbeaver.db.dynamodb.model.DynamoTableKey;
import com.dbeaver.ee.model.document.DBAbstractDocument;
import com.dbeaver.ee.model.document.DBMapValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoDocument
extends DBAbstractDocument<DynamoDataSource, Map<String, AttributeValue>> {
    private static final Log log = Log.getLog(DynamoDocument.class);
    public static Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").registerTypeAdapter(AttributeValue.class, (Object)new AttributeValueConverter()).serializeNulls().create();
    @Nullable
    private DynamoTable table;

    public DynamoDocument(@NotNull DynamoDataSource dataSource, @Nullable DynamoTable table, Map<String, AttributeValue> item) {
        super((DBPDataSource)dataSource, item);
        this.table = table;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getDocumentProperty(String name) {
        switch (name) {
            case "id": {
                try {
                    DynamoTableKey key;
                    if (this.table == null) {
                        return null;
                    }
                    DynamoTableKey dynamoTableKey = key = this.table.getKey((DBRProgressMonitor)new VoidProgressMonitor());
                    if (key == null) {
                        return null;
                    }
                    StringBuilder idStr = new StringBuilder();
                    Iterator<DynamoTableKey.KeyAttribute> iterator = key.getAttributes().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return idStr.toString();
                        }
                        DynamoTableKey.KeyAttribute attr = iterator.next();
                        AttributeValue attributeValue = (AttributeValue)((Map)this.rawValue).get(attr.getName());
                        Object rawValue = DynamoDBUtils.getRawAttributeValue((DynamoDataSource)this.dataSource, (DBSAttributeBase)attr.getAttribute(), attributeValue);
                        if (idStr.length() > 0) {
                            idStr.append(", ");
                        }
                        idStr.append(attr.getName()).append("=").append(rawValue);
                    }
                }
                catch (DBException e) {
                    log.error((Object)e);
                    return null;
                }
            }
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    protected DBMapValue<DynamoDataSource> makeRawMap() {
        return DynamoDBUtils.makeRawMap((DynamoDataSource)this.dataSource, this.table, (Map)this.rawValue);
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull OutputStream stream, String encoding) throws DBException, IOException {
        String json = JSON_BUILDER.toJson(this.getRawValue());
        stream.write(json.getBytes(encoding));
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull InputStream stream, String encoding) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.rawMap = new DBMapValue(this.dataSource, (Map)JSON_BUILDER.fromJson((Reader)reader, Map.class));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public DynamoDocument copy() {
        return new DynamoDocument((DynamoDataSource)this.dataSource, this.table, this.rawValue == null ? null : new LinkedHashMap((Map)this.rawValue));
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        DBSAttributeBase[] attrs = new DBSAttributeBase[((Map)this.rawValue).size()];
        int attrIndex = 0;
        for (String attrName : ((Map)this.rawValue).keySet()) {
            DynamoTableAttribute tableAttribute = this.table == null ? null : this.table.getAttribute(null, attrName);
            attrs[attrIndex] = tableAttribute != null ? tableAttribute : new DBAbstractDocument.DocumentAttribute(attrIndex, attrName);
            ++attrIndex;
        }
        return attrs;
    }

    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        AttributeValue value = (AttributeValue)((Map)this.rawValue).get(attribute.getName());
        if (value != null) {
            return DynamoDBUtils.getRawAttributeValue((DynamoDataSource)this.dataSource, attribute, value);
        }
        return null;
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, Object value) {
    }

    public static class AttributeValueConverter
    implements JsonSerializer<AttributeValue>,
    JsonDeserializer<AttributeValue> {
        public JsonElement serialize(AttributeValue src, Type srcType, JsonSerializationContext context) {
            return DynamoDBUtils.getJsonAttributeValue(src);
        }

        public AttributeValue deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return (AttributeValue)AttributeValue.builder().n(json.getAsString()).build();
        }
    }
}

