/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.net;

import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class SocksProxyConfiguratorUI
implements IObjectPropertyConfigurator<DBWHandlerConfiguration> {
    private Text hostText;
    private Spinner portText;
    private Text userNameText;
    private Text passwordText;
    private Button savePasswordCheckbox;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.hostText = UIUtils.createLabelText((Composite)composite, (String)CoreMessages.dialog_connection_network_socket_label_host, null);
        this.hostText.setLayoutData((Object)new GridData(768));
        this.portText = UIUtils.createLabelSpinner((Composite)composite, (String)CoreMessages.dialog_connection_network_socket_label_port, (int)1080, (int)0, (int)65535);
        this.userNameText = UIUtils.createLabelText((Composite)composite, (String)CoreMessages.dialog_connection_network_socket_label_username, null);
        this.userNameText.setLayoutData((Object)new GridData(768));
        this.passwordText = UIUtils.createLabelText((Composite)composite, (String)CoreMessages.dialog_connection_network_socket_label_password, (String)"", (int)0x400800);
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.savePasswordCheckbox = UIUtils.createCheckbox((Composite)composite, (String)CoreMessages.dialog_connection_auth_checkbox_save_password, (boolean)false);
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        this.hostText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("socks-host"))));
        String portString = (String)configuration.getProperties().get("socks-port");
        if (!CommonUtils.isEmpty((String)portString)) {
            this.portText.setSelection(CommonUtils.toInt((Object)portString));
        }
        this.userNameText.setText(CommonUtils.notEmpty((String)configuration.getUserName()));
        this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getPassword()));
        this.savePasswordCheckbox.setSelection(configuration.isSavePassword());
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        Map properties = configuration.getProperties();
        properties.clear();
        properties.put("socks-host", this.hostText.getText());
        properties.put("socks-port", this.portText.getText());
        configuration.setUserName(this.userNameText.getText());
        configuration.setPassword(this.passwordText.getText());
        configuration.setSavePassword(this.savePasswordCheckbox.getSelection());
    }

    public void resetSettings(DBWHandlerConfiguration configuration) {
    }

    public boolean isComplete() {
        return false;
    }
}

