/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.model;

import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.exec.RedisSession;
import com.dbeaver.ee.redis.model.RedisDataSource;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.BaseDataSourceInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class RedisDataSourceInfo
extends BaseDataSourceInfo {
    private static final Log log = Log.getLog(RedisDataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "redis.clients.jedis";
    private final RedisDataSource dataSource;
    private Map<String, Object> serverInfoMap;

    public RedisDataSourceInfo(RedisDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isReadOnlyData() {
        return false;
    }

    public boolean isReadOnlyMetaData() {
        return false;
    }

    public String getDatabaseProductName() {
        return "Redis";
    }

    public String getDatabaseProductVersion() {
        Map<String, Object> details = this.getDatabaseProductDetails();
        if (details == null) {
            return null;
        }
        return details.get("redis_version") + " (" + details.get("redis_mode") + ")" + "\n" + details.get("os");
    }

    public Map<String, Object> getDatabaseProductDetails() {
        if (this.serverInfoMap == null) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBPDataSource)this.dataSource, (String)"Read Redis server info");){
                String serverInfo = session.getJedis().info("server");
                this.serverInfoMap = RedisUtils.parseInfo(serverInfo);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.serverInfoMap;
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Jedis driver bundle 'redis.clients.jedis' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        return this.getDriverBundle().getVersion();
    }

    public String getDriverName() {
        return (String)this.getDriverBundle().getHeaders().get("Bundle-Name");
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return "Database";
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return "Database";
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsReferentialIntegrity() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsStoredCode() {
        return false;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean isDynamicMetadata() {
        return true;
    }
}

