/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.exec;

import com.dbeaver.ee.model.NoSQLConstants;
import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.exec.RedisCommandStatement;
import com.dbeaver.ee.redis.exec.RedisEvalStatement;
import com.dbeaver.ee.redis.exec.RedisExecutionContext;
import com.dbeaver.ee.redis.exec.RedisQueryStatement;
import com.dbeaver.ee.redis.model.RedisDataSource;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import redis.clients.jedis.Jedis;

public class RedisSession
extends AbstractSession {
    private static final Log log = Log.getLog(RedisSession.class);
    private final RedisExecutionContext executionContext;
    private Jedis jedis;

    public RedisSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle, RedisExecutionContext executionContext) {
        super(monitor, purpose, taskTitle);
        this.executionContext = executionContext;
        this.jedis = executionContext.acquireJedis();
    }

    public Jedis getJedis() {
        return this.jedis;
    }

    @NotNull
    public RedisExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public RedisDataSource getDataSource() {
        return (RedisDataSource)this.executionContext.getDataSource();
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        if (NoSQLConstants.SQL_PATTERN.matcher(query = query.trim()).matches()) {
            return new RedisQueryStatement(this, query);
        }
        if (query.startsWith("{") || query.toUpperCase(Locale.ENGLISH).startsWith("BEGIN")) {
            query = query.startsWith("{") ? query.substring(1, query.length() - 1) : query.substring("BEGIN".length(), query.length() - "END".length()).trim();
            return new RedisEvalStatement(this, query);
        }
        String[] command = ((RedisDataSource)this.executionContext.getDataSource()).parseCommand(query);
        if (RedisUtils.isCommand(command[0].toLowerCase(Locale.ENGLISH))) {
            return new RedisCommandStatement(this, command);
        }
        return new RedisEvalStatement(this, query);
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        throw new DBException("Redis session cancel not implemented");
    }

    public void close() {
        try {
            this.jedis.close();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        super.close();
    }
}

