/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.views;

import com.dbeaver.ee.redis.Activator;
import com.dbeaver.ee.redis.RedisMessages;
import com.dbeaver.ee.redis.views.RedisKeysConfigPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class RedisConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private static final Log log = Log.getLog(RedisConnectionPage.class);
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/redis_logo.png");
    private Composite settingsGroup;
    private Text hostText;
    private Text portText;
    private Text passwordText;
    private Spinner connectTimeout;
    private Spinner socketTimeout;
    private boolean activated;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)RedisMessages.connection_page_group_server, (int)4, (int)768, (int)-1);
        this.hostText = UIUtils.createLabelText((Composite)serverGroup, (String)RedisMessages.connection_page_group_host, (String)"");
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)serverGroup, (String)RedisMessages.connection_page_label_text_port, (String)"");
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.passwordText = UIUtils.createLabelText((Composite)serverGroup, (String)RedisMessages.connection_page_label_text_password, (String)"", (int)0x400800);
        gd = new GridData(32);
        gd.widthHint = 200;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        this.createSavePasswordButton((Composite)serverGroup, 2);
        serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)RedisMessages.connection_page_group_connection_settings, (int)2, (int)768, (int)-1);
        this.connectTimeout = UIUtils.createLabelSpinner((Composite)serverGroup, (String)RedisMessages.connection_page_label_spinner_connect_timeout, (String)RedisMessages.connection_page_label_spinner_tip_connect_timeout, (int)10000, (int)0, (int)Integer.MAX_VALUE);
        this.connectTimeout.setLayoutData((Object)new GridData(32));
        this.connectTimeout.addModifyListener(textListener);
        this.socketTimeout = UIUtils.createLabelSpinner((Composite)serverGroup, (String)RedisMessages.connection_page_label_spinner_socket_timeout, (String)RedisMessages.connection_page_label_spinner_tip_socket_timeout, (int)100000, (int)0, (int)Integer.MAX_VALUE);
        gd = new GridData(2);
        gd.widthHint = 60;
        this.socketTimeout.setLayoutData((Object)gd);
        this.socketTimeout.addModifyListener(textListener);
        this.createDriverPanel(this.settingsGroup);
        return this.settingsGroup;
    }

    public boolean isComplete() {
        return !this.hostText.getText().isEmpty() && !this.portText.getText().isEmpty();
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            String timeout;
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
            } else {
                this.hostText.setText("localhost");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
            if (connectionInfo.getUserPassword() != null) {
                this.passwordText.setText(connectionInfo.getUserPassword());
            }
            if ((timeout = connectionInfo.getProviderProperty("@dbeaver-redis.timeout.connect")) == null) {
                timeout = String.valueOf(10000);
            }
            try {
                this.connectTimeout.setSelection(Integer.parseInt(timeout));
            }
            catch (NumberFormatException e) {
                log.debug((Object)e);
            }
            timeout = connectionInfo.getProviderProperty("@dbeaver-redis.timeout.socket");
            if (timeout == null) {
                timeout = String.valueOf(100000);
            }
            try {
                this.socketTimeout.setSelection(Integer.parseInt(timeout));
            }
            catch (NumberFormatException e) {
                log.debug((Object)e);
            }
        }
        super.loadSettings();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
            connectionInfo.setHostPort(this.portText.getText().trim());
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        connectionInfo.setProviderProperty("@dbeaver-redis.timeout.connect", String.valueOf(this.connectTimeout.getSelection()));
        connectionInfo.setProviderProperty("@dbeaver-redis.timeout.socket", String.valueOf(this.socketTimeout.getSelection()));
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getSubPages() {
        return new IDialogPage[]{new RedisKeysConfigPage()};
    }
}

