/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.data.handlers;

import com.dbeaver.ee.mongodb.exec.MongoCustomStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.BaseValueHandler;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public abstract class MongoBaseValueHandler
extends BaseValueHandler {
    private static final Log log = Log.getLog(MongoBaseValueHandler.class);

    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        if (type instanceof DBSAttributeBase && type.getDataKind() != DBPDataKind.DOCUMENT) {
            return resultSet.getAttributeValue(((DBSAttributeBase)type).getName());
        }
        return resultSet.getAttributeValue(index);
    }

    public final void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject columnMetaData, int index, Object value) throws DBCException {
        try {
            this.bindParameter((MongoSession)session, (MongoCustomStatement)statement, columnMetaData, index, value);
        }
        catch (Exception e) {
            throw new DBCException("Error binding statement parameter", (Throwable)e);
        }
    }

    protected abstract void bindParameter(MongoSession var1, MongoCustomStatement var2, DBSTypedObject var3, int var4, Object var5) throws DBCException;

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        ArrayList<DBCLogicalOperator> operators = new ArrayList<DBCLogicalOperator>();
        DBPDataKind dataKind = attribute.getDataKind();
        if (dataKind == DBPDataKind.BOOLEAN) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
        } else if (dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME || dataKind == DBPDataKind.STRING || dataKind == DBPDataKind.ROWID) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
            operators.add(DBCLogicalOperator.GREATER);
            operators.add(DBCLogicalOperator.LESS);
            operators.add(DBCLogicalOperator.IN);
            if (dataKind == DBPDataKind.STRING) {
                operators.add(DBCLogicalOperator.LIKE);
            }
        }
        return operators.toArray(new DBCLogicalOperator[operators.size()]);
    }
}

