/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tools.sqldeveloper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.import_config.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportData;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.ext.oracle.Activator;
import org.jkiss.dbeaver.ext.oracle.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionType;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigImportWizardPageSqlDeveloper
extends ConfigImportWizardPage {
    public static final String SQLD_HOME_FOLDER = "SQL Developer";
    public static final String SQLD_CONFIG_FILE = "connections.xml";
    public static final String SQLD_CONFIG_JSON_FILE = "connections.json";
    public static final String SQLD_SYSCONFIG_FOLDER = "system";
    public static final String SQLD_CONNECTIONS_FOLDER = "o.jdeveloper.db.connection";
    private static final Log log = Log.getLog(ConfigImportWizardPageSqlDeveloper.class);
    private final ImportDriverInfo oraDriver;

    protected ConfigImportWizardPageSqlDeveloper() {
        super("SQLDeveloper");
        this.setTitle(SQLD_HOME_FOLDER);
        this.setDescription("Import Oracle SQL Developer connections");
        this.setImageDescriptor(Activator.getImageDescriptor("icons/sqldeveloper_big.png"));
        this.oraDriver = new ImportDriverInfo(null, "Oracle", "jdbc:oracle:thin:@{host}[:{port}]/{database}", "oracle.jdbc.OracleDriver");
    }

    protected void loadConnections(ImportData importData) throws DBException {
        importData.addDriver(this.oraDriver);
        File homeFolder = RuntimeUtils.getUserHomeDir();
        File sqlDevHome = new File(homeFolder, "AppData/Roaming/SQL Developer");
        if (!(sqlDevHome.exists() || (sqlDevHome = new File(homeFolder, "Application Data/SQL Developer")).exists() || (sqlDevHome = new File(homeFolder, ".sqldeveloper")).exists())) {
            throw new DBException(OracleMessages.config_import_wizard_page_sql_developer_label_installation_not_found);
        }
        File[] sysConfFolders = sqlDevHome.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(ConfigImportWizardPageSqlDeveloper.SQLD_SYSCONFIG_FOLDER);
            }
        });
        if (sysConfFolders == null || sysConfFolders.length == 0) {
            throw new DBException("SQL Developer config not found");
        }
        File[] fileArray = sysConfFolders;
        int n = sysConfFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File sysConfFolder = fileArray[n2];
            File[] connectionFolders = sysConfFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(ConfigImportWizardPageSqlDeveloper.SQLD_CONNECTIONS_FOLDER);
                }
            });
            if (connectionFolders != null && connectionFolders.length == 1) {
                File connectionFolder = connectionFolders[0];
                File connectionsJsonFile = new File(connectionFolder, SQLD_CONFIG_JSON_FILE);
                File connectionsFile = new File(connectionFolder, SQLD_CONFIG_FILE);
                if (connectionsFile.exists()) {
                    this.parseConnections(connectionsFile, importData);
                } else if (connectionsJsonFile.exists()) {
                    this.parseJsonConnections(connectionsJsonFile, importData);
                }
            }
            ++n2;
        }
    }

    private void parseJsonConnections(File connectionsFile, ImportData importData) throws JsonSyntaxException {
        try {
            Gson gson = new GsonBuilder().create();
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(connectionsFile));){
                ConnectionList connResult = (ConnectionList)gson.fromJson((Reader)br, ConnectionList.class);
                for (ConnectionDescription conn : connResult.getConnections()) {
                    ConnectionInfo info;
                    if (CommonUtils.isEmpty((String)conn.getName()) || CommonUtils.isEmpty((String)(info = conn.getInfo()).getHost()) && CommonUtils.isEmpty((String)info.getUrl())) continue;
                    String dbName = CommonUtils.isEmpty((String)info.getSID()) ? info.getServiceName() : info.getSID();
                    ImportConnectionInfo connectionInfo = new ImportConnectionInfo(this.oraDriver, null, conn.getName(), info.getUrl(), info.getHost(), info.getPort(), dbName, info.getHost(), null);
                    if (!CommonUtils.isEmpty((String)info.getSID())) {
                        connectionInfo.setProviderProperty("@dbeaver-sid-service@", OracleConnectionType.SID.name());
                    } else if (!CommonUtils.isEmpty((String)info.getServiceName())) {
                        connectionInfo.setProviderProperty("@dbeaver-sid-service@", OracleConnectionType.SERVICE.name());
                    }
                    if (CommonUtils.toBoolean((Object)info.getOsAuth())) {
                        connectionInfo.setUser("@dbeaver-os-authentication@");
                    }
                    if (!CommonUtils.isEmpty((String)info.getRole())) {
                        connectionInfo.setProviderProperty("@dbeaver-internal-logon@", info.getRole());
                    }
                    if (!CommonUtils.isEmpty((String)conn.getType())) {
                        connectionInfo.setProviderProperty("@dbeaver-connection-type@", conn.getType());
                    }
                    importData.addConnection(connectionInfo);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Configuration parse error", (Throwable)e);
        }
    }

    private void parseConnections(File connectionsFile, ImportData importData) throws DBException {
        try {
            Document configDocument = XMLUtils.parseDocument((File)connectionsFile);
            for (Element refElement : XMLUtils.getChildElementList((Element)configDocument.getDocumentElement(), (String)"Reference")) {
                String conName = refElement.getAttribute("name");
                if (CommonUtils.isEmpty((String)conName)) continue;
                LinkedHashMap<String, String> propsMap = new LinkedHashMap<String, String>();
                Element refAddressesElement = XMLUtils.getChildElement((Element)refElement, (String)"RefAddresses");
                if (refAddressesElement != null) {
                    for (Element refAddr : XMLUtils.getChildElementList((Element)refAddressesElement, (String)"StringRefAddr")) {
                        String addrType = refAddr.getAttribute("addrType");
                        String addrContent = XMLUtils.getChildElementBody((Element)refAddr, (String)"Contents");
                        if (CommonUtils.isEmpty((String)addrType) || CommonUtils.isEmpty((String)addrContent)) continue;
                        propsMap.put(addrType, addrContent);
                    }
                }
                String host = (String)propsMap.get("hostname");
                String port = (String)propsMap.get("port");
                String sid = (String)propsMap.get("sid");
                String serviceName = (String)propsMap.get("serviceName");
                String user = (String)propsMap.get("user");
                String role = (String)propsMap.get("role");
                String osAuth = (String)propsMap.get("OS_AUTHENTICATION");
                String url = (String)propsMap.get("customUrl");
                if (CommonUtils.isEmpty((String)host) && CommonUtils.isEmpty((String)url)) continue;
                String dbName = CommonUtils.isEmpty((String)sid) ? serviceName : sid;
                ImportConnectionInfo connectionInfo = new ImportConnectionInfo(this.oraDriver, null, conName, url, host, port, dbName, user, null);
                if (!CommonUtils.isEmpty((String)sid)) {
                    connectionInfo.setProviderProperty("@dbeaver-sid-service@", OracleConnectionType.SID.name());
                } else if (!CommonUtils.isEmpty((String)serviceName)) {
                    connectionInfo.setProviderProperty("@dbeaver-sid-service@", OracleConnectionType.SERVICE.name());
                }
                if (CommonUtils.toBoolean((Object)osAuth)) {
                    connectionInfo.setUser("@dbeaver-os-authentication@");
                }
                if (!CommonUtils.isEmpty((String)role)) {
                    connectionInfo.setProviderProperty("@dbeaver-internal-logon@", role);
                }
                importData.addConnection(connectionInfo);
            }
        }
        catch (XMLException e) {
            throw new DBException("Configuration parse error: " + e.getMessage());
        }
    }

    public static class ConnectionDescription {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="info")
        private ConnectionInfo info;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public ConnectionInfo getInfo() {
            return this.info;
        }

        public void setInfo(ConnectionInfo info) {
            this.info = info;
        }
    }

    public class ConnectionInfo {
        @SerializedName(value="role")
        private String role;
        @SerializedName(value="hostname")
        private String hostname;
        @SerializedName(value="port")
        private String port;
        @SerializedName(value="sid")
        private String sid;
        @SerializedName(value="serviceName")
        private String serviceName;
        @SerializedName(value="user")
        private String user;
        @SerializedName(value="customUrl")
        private String customUrl;
        @SerializedName(value="OS_AUTHENTICATION")
        private String OsAuth;

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getHost() {
            return this.hostname;
        }

        public void setHost(String hostname) {
            this.hostname = hostname;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getSID() {
            return this.sid;
        }

        public void setSID(String sid) {
            this.sid = sid;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getUrl() {
            return this.customUrl;
        }

        public void setUrl(String customUrl) {
            this.customUrl = customUrl;
        }

        public String getOsAuth() {
            return this.OsAuth;
        }

        public void setOsAuth(String OS_AUTHENTICATION) {
            this.OsAuth = OS_AUTHENTICATION;
        }
    }

    public static class ConnectionList {
        @SerializedName(value="connections")
        private List<ConnectionDescription> connections = new ArrayList<ConnectionDescription>();

        public List<ConnectionDescription> getConnections() {
            return this.connections;
        }
    }
}

