/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.i18n.text.OraCollator;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.PagedNodeList;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLDocumentBuilder;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

public class XSLSort
extends XSLNode
implements XSLConstants {
    private static final String SELECT_ATTR = "select";
    private static final String ORDER_ATTR = "order";
    private static final String LANG_ATTR = "lang";
    private static final String STABLE_ATTR = "stable";
    private static final String DATA_TYPE_ATTR = "data-type";
    private static final String CASE_ORDER_ATTR = "case-order";
    private static final String UPPER_FIRST = "upper-first";
    private static final String LOWER_FIRST = "lower-first";
    private static final String ASCENDING_ORDER = "ascending";
    private static final String DESCENDING_ORDER = "descending";
    private static final String TEXT_TYPE = "text";
    private static final String NUMBER_TYPE = "number";
    private boolean debug = false;
    private XSLSort m_seckey;
    private XSLExprBase m_selectexpr;
    private boolean m_blnTextType = true;
    private String m_strTextType = "text";
    private boolean m_blnAscending = true;
    private String m_strAscending = "ascending";
    private int m_intCaseOrder = 0;
    private String m_strCaseOrder = null;
    private URL m_collationURI;
    private String m_strStable = null;
    private RuleBasedCollator m_usCollator;
    private Collator m_collator;
    private RuleBasedCollator m_udCollator;
    private OraCollator m_oraCollator;
    private boolean m_blnIsEnglish = true;
    private int m_iIsUserDefinedCollator = 0;
    private String m_strLang = "";
    private static final String UNICODE_TBL_BEFORE_ZERO = " < ' ' < '!' < '\"' < '#' < '$' < '%' < '&' < ''' < '(' < ')' < '*' < '+' < ',' < '-' < '.' < '/'";
    private static final String UNICODE_TBL_BETWEEN_9_AND_A = " < ':' < ';' < '<' < '=' < '>' < '?' < '@'";
    private static final String UNICODE_TBL_BETWEEN_Z_AND_a = " < '[' < '\\' < ']' < '^' < '_' < '`'";
    private static final String UNICODE_TBL_BETWEEN_0_AND_9 = " < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9";
    private XSLNode.AttrValueTmpl m_atvText;
    private XSLNode.AttrValueTmpl m_atvAsc;
    private XSLNode.AttrValueTmpl m_atvCaseOrder;
    private XSLNode.AttrValueTmpl m_atvCollationURI;
    private XSLNode.AttrValueTmpl m_atvStable;
    private boolean m_isATV = false;
    private boolean m_isNonEmptyContent = false;
    private boolean m_isStable = true;
    private boolean m_isSecKey = false;

    XSLSort(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        XSLNode.AttrValueTmpl attrValueTmpl = new XSLNode.AttrValueTmpl(string4, this);
        boolean bl = this.m_isATV = attrValueTmpl.isAttrValueTmpl() || this.m_isATV;
        if (string == "") {
            if (string3 == SELECT_ATTR) {
                this.m_selectexpr = XSLExprBase.createExpression(string4, (NSResolver)this, this.xss);
            } else if (string3 == "collation" && this.version >= 20) {
                this.m_atvCollationURI = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == DATA_TYPE_ATTR) {
                this.m_strTextType = string4;
                this.m_atvText = new XSLNode.AttrValueTmpl(this.m_strTextType, this);
            } else if (string3 == ORDER_ATTR) {
                this.m_strAscending = string4;
                this.m_atvAsc = new XSLNode.AttrValueTmpl(this.m_strAscending, this);
            } else if (string3 == LANG_ATTR) {
                this.m_strLang = string4.intern();
            } else if (string3 == CASE_ORDER_ATTR) {
                this.m_strCaseOrder = string4;
                this.m_atvCaseOrder = new XSLNode.AttrValueTmpl(this.m_strCaseOrder, this);
            } else if (string3 == STABLE_ATTR) {
                if (this.m_isSecKey) {
                    this.xss.err.error0(1068, 1);
                } else {
                    this.m_strStable = string4;
                    this.m_atvStable = new XSLNode.AttrValueTmpl(this.m_strStable, this);
                }
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    @Override
    public void startContent() throws XSLException, XQException {
        this.handleLanguageCollator();
        if (this.getXSLTVersion() >= 20) {
            this.elementType = 6;
        }
    }

    @Override
    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        this.m_isNonEmptyContent = true;
    }

    @Override
    void endContent() throws XSLException, XQException {
        super.endContent();
        if (this.m_isNonEmptyContent && this.m_selectexpr != null) {
            this.xss.err.error1(1066, 1, "xsl:sort");
        } else if (!this.m_isNonEmptyContent && this.m_selectexpr == null) {
            this.m_selectexpr = XSLExprBase.createExpression(".", (NSResolver)this, this.xss);
        }
    }

    void addSecondaryKey(XSLSort xSLSort) throws XSLException {
        xSLSort.m_isSecKey = true;
        if (this.m_seckey == null) {
            this.m_seckey = xSLSort;
        } else {
            this.m_seckey.addSecondaryKey(xSLSort);
        }
    }

    XSLSort getSecondaryKey() {
        return this.m_seckey;
    }

    private OXMLSequence getValue(XSLTContext xSLTContext) throws XSLException {
        OXMLSequence oXMLSequence;
        if (this.m_selectexpr != null) {
            this.m_selectexpr.evaluate(xSLTContext);
            oXMLSequence = xSLTContext.popExprValue();
        } else {
            oXMLSequence = new XPathSequence(xSLTContext);
            XSLDocumentBuilder xSLDocumentBuilder = xSLTContext.allocXSLDocumentBuilder();
            XSLEventHandler xSLEventHandler = xSLTContext.allocXSLEventHandler();
            xSLEventHandler.reset(xSLDocumentBuilder, xSLDocumentBuilder, xSLTContext);
            xSLDocumentBuilder.setVariableContext(true);
            XSLEventHandler xSLEventHandler2 = xSLTContext.getEventHandler();
            xSLTContext.setEventHandler(xSLEventHandler);
            this.processChildren(xSLTContext);
            xSLEventHandler.flushEvents();
            XPathItem xPathItem = xSLTContext.allocItem();
            ((OXMLItem)xPathItem).setNode(xSLDocumentBuilder.getResultFragment());
            oXMLSequence.appendItem(xPathItem);
            xSLTContext.setEventHandler(xSLEventHandler2);
            xSLDocumentBuilder.setVariableContext(false);
            xSLTContext.freeXSLDocumentBuilder(xSLDocumentBuilder);
            xSLTContext.freeXSLEventHandler(xSLEventHandler);
        }
        return oXMLSequence;
    }

    private void prepareAttributeTemplateValue(XSLTContext xSLTContext) throws XSLException, XQException {
        String string = null;
        if (this.m_atvCollationURI != null) {
            string = this.m_atvCollationURI.getValue(xSLTContext);
            if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
                this.m_iIsUserDefinedCollator = 1;
                if (this.m_oraCollator == null) {
                    this.m_oraCollator = OraCollator.getInstance((String)"BINARY", (String)"AL32UTF8");
                }
            } else {
                try {
                    this.m_collationURI = this.baseURL == null ? new URL(string) : new URL(this.baseURL, string);
                }
                catch (MalformedURLException malformedURLException) {
                    this.m_collationURI = null;
                    this.m_udCollator = null;
                    this.m_iIsUserDefinedCollator = 0;
                }
                if (this.m_collationURI != null) {
                    Object object;
                    int n = 1024;
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    String string2 = "UTF-8";
                    try {
                        int n3;
                        object = this.m_collationURI.openConnection();
                        string2 = ((URLConnection)object).getContentEncoding();
                        if (string2 == null) {
                            string2 = "UTF-8";
                        }
                        InputStream inputStream = ((URLConnection)object).getInputStream();
                        while ((n3 = inputStream.read()) != -1) {
                            byArray[n2++] = (byte)n3;
                            if (n2 != n) continue;
                            byte[] byArray2 = new byte[n * 2];
                            System.arraycopy(byArray, 0, byArray2, 0, n);
                            n *= 2;
                            byArray = byArray2;
                            byArray2 = null;
                        }
                        inputStream.close();
                    }
                    catch (NullPointerException nullPointerException) {
                        this.m_collationURI = null;
                        this.m_udCollator = null;
                        this.m_iIsUserDefinedCollator = 0;
                    }
                    catch (IOException iOException) {
                        throw new XSLException(iOException.getMessage());
                    }
                    try {
                        object = new String(byArray, 0, n2, string2);
                        this.m_udCollator = new RuleBasedCollator((String)object);
                        this.m_iIsUserDefinedCollator = 2;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new XSLException(unsupportedEncodingException.getMessage());
                    }
                    catch (ParseException parseException) {
                        throw new XSLException(parseException.getMessage());
                    }
                }
            }
        }
        string = this.m_atvText != null ? this.m_atvText.getValue(xSLTContext).intern() : this.m_strTextType;
        this.m_blnTextType = string != NUMBER_TYPE;
        string = this.m_atvAsc != null ? this.m_atvAsc.getValue(xSLTContext).intern() : this.m_strAscending;
        if (string == DESCENDING_ORDER) {
            this.m_blnAscending = false;
        } else if (string == ASCENDING_ORDER) {
            this.m_blnAscending = true;
        }
        string = this.m_atvCaseOrder != null ? this.m_atvCaseOrder.getValue(xSLTContext).intern() : this.m_strCaseOrder;
        if (string == UPPER_FIRST) {
            this.m_intCaseOrder = 1;
        } else if (string == LOWER_FIRST) {
            this.m_intCaseOrder = 2;
        }
        if (this.m_usCollator == null || this.m_isATV) {
            this.fillRuleBaseTables(xSLTContext);
        }
        if ((string = this.m_atvStable != null ? this.m_atvStable.getValue(xSLTContext).intern() : this.m_strStable) == "no") {
            this.m_isStable = false;
        }
    }

    public void sortNodes(XSLTContext xSLTContext) throws XSLException, XQException {
        XPathSequence xPathSequence = (XPathSequence)xSLTContext.peekExprValue();
        if (this.m_seckey == null && xSLTContext.getPageManager() != null && !xSLTContext.isSortingGroup() && xSLTContext.getContextNode().isNodeFlag(2048) && xPathSequence.isStreaming() && !this.xss.getPrecedingAxis()) {
            this.sortNodesLazy(xSLTContext);
            return;
        }
        this.setContextBaseURL(xSLTContext);
        ArrayList<XMLNode> arrayList = new ArrayList<XMLNode>();
        while (xPathSequence.next()) {
            arrayList.add(XPathSequence.nextNode(xPathSequence));
        }
        int n = arrayList.size();
        xSLTContext.setContextSize(n);
        ArrayList<XMLNode> arrayList2 = null;
        if (xSLTContext.isSortingGroup()) {
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            for (int i = 0; i < n; ++i) {
                arrayList3.add(i);
            }
            arrayList2 = this.sorting(xSLTContext, arrayList, arrayList3);
        } else {
            arrayList2 = this.sorting(xSLTContext, arrayList, null);
        }
        n = arrayList2.size();
        xPathSequence.reset();
        for (int i = 0; i < n; ++i) {
            XPathSequence.addNode(xPathSequence, arrayList2.get(i));
        }
    }

    private ArrayList<XMLNode> sorting(XSLTContext xSLTContext, ArrayList<XMLNode> arrayList, ArrayList<Integer> arrayList2) throws XSLException, XQException {
        Object object;
        ArrayList<XMLNode> arrayList3;
        int n;
        this.prepareAttributeTemplateValue(xSLTContext);
        Hashtable<String, ArrayList<XMLNode>> hashtable = new Hashtable<String, ArrayList<XMLNode>>(20);
        int n2 = arrayList.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        Hashtable<String, ArrayList<Integer>> hashtable2 = null;
        ArrayList<Integer> arrayList4 = null;
        if (xSLTContext.isSortingGroup()) {
            hashtable2 = new Hashtable<String, ArrayList<Integer>>(20);
        }
        for (n = 0; n < n2; ++n) {
            String string;
            XMLNode xMLNode = arrayList.get(n);
            xSLTContext.setContextPosition(n + 1);
            xSLTContext.setContextNode(xMLNode);
            if (xSLTContext.isSortingGroup()) {
                xSLTContext.setSortingGrpIdx(arrayList2.get(n));
            }
            if ((arrayList3 = (ArrayList)hashtable.get(string = XPathSequence.getStringValue((OXMLSequence)(object = this.getValue(xSLTContext))))) == null) {
                arrayList3 = new ArrayList<XMLNode>();
                arrayList3.add(xMLNode);
                hashtable.put(string, arrayList3);
                stringArray[n3++] = string;
                if (!xSLTContext.isSortingGroup()) continue;
                arrayList4 = new ArrayList<Integer>();
                arrayList4.add(arrayList2.get(n));
                hashtable2.put(string, arrayList4);
                continue;
            }
            arrayList3.add(xMLNode);
            if (!xSLTContext.isSortingGroup()) continue;
            arrayList4 = (ArrayList)hashtable2.get(string);
            arrayList4.add(arrayList2.get(n));
        }
        object = this.sortObjects(stringArray, n3);
        ArrayList<XMLNode> arrayList5 = new ArrayList<XMLNode>();
        boolean bl = false;
        int n4 = n3;
        for (n = 0; n < n3; ++n) {
            int n5;
            arrayList3 = (ArrayList<XMLNode>)hashtable.get(object[n]);
            if (xSLTContext.isSortingGroup()) {
                arrayList4 = (ArrayList<Integer>)hashtable2.get(object[n]);
            }
            int n6 = arrayList3.size();
            if (this.m_seckey != null) {
                if (n6 > 1) {
                    arrayList3 = this.m_seckey.sorting(xSLTContext, arrayList3, arrayList4);
                    for (n5 = 0; n5 < n6; ++n5) {
                        arrayList5.add(arrayList3.get(n5));
                    }
                    continue;
                }
                arrayList5.add((XMLNode)arrayList3.get(0));
                continue;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                arrayList5.add(arrayList3.get(n5));
            }
        }
        return arrayList5;
    }

    private String[] sortObjects(String[] stringArray, int n) throws XSLException {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public final int compare(String string, String string2) {
                return XSLSort.this.compareObjects(string, string2);
            }
        };
        Arrays.sort(stringArray, 0, n, comparator);
        return stringArray;
    }

    private void sortNodesLazy(XSLTContext xSLTContext) throws XSLException {
        int n = 1;
        PagedNodeList pagedNodeList = null;
        XPathSequence xPathSequence = (XPathSequence)xSLTContext.peekExprValue();
        this.prepareAttributeTemplateValue(xSLTContext);
        if (xPathSequence.next()) {
            XMLNode xMLNode = XPathSequence.nextNode(xPathSequence);
            XMLDocument xMLDocument = (XMLDocument)xMLNode.getOwnerDocument();
            pagedNodeList = new PagedNodeList(xSLTContext.getPageManager(), xMLDocument.getInfosetReader(), (XMLElement)xMLNode.getParentNode());
            pagedNodeList.setSort(xSLTContext, this);
            xSLTContext.setContextPosition(n++);
            xSLTContext.setContextNode(xMLNode);
            this.m_selectexpr.evaluate(xSLTContext);
            pagedNodeList.addNode(xMLNode, XPathSequence.getStringValue(xSLTContext.popExprValue()));
            while (xPathSequence.next()) {
                xMLNode = XPathSequence.nextNode(xPathSequence);
                xSLTContext.setContextPosition(n++);
                xSLTContext.setContextNode(xMLNode);
                this.m_selectexpr.evaluate(xSLTContext);
                pagedNodeList.addNode(xMLNode, XPathSequence.getStringValue(xSLTContext.popExprValue()));
            }
            pagedNodeList.flushPage();
            pagedNodeList.finishSort();
            pagedNodeList.start();
            xPathSequence.reset();
            xPathSequence.setPagedNodeList(pagedNodeList);
        }
    }

    public String getKeyValue(XSLTContext xSLTContext, XMLNode xMLNode) throws XSLException {
        xSLTContext.setContextNode(xMLNode);
        this.m_selectexpr.evaluate(xSLTContext);
        return XPathSequence.getStringValue(xSLTContext.popExprValue());
    }

    public int compareObjects(Object object, Object object2) {
        String string = "";
        String string2 = "";
        if (object != null) {
            string = object.toString();
        }
        if (object2 != null) {
            string2 = object2.toString();
        }
        int n = this.m_blnTextType ? (this.m_iIsUserDefinedCollator == 2 ? this.m_udCollator.compare(string, string2) : (this.m_iIsUserDefinedCollator == 1 ? this.m_oraCollator.compare(string, string2) : (this.m_blnIsEnglish ? this.m_usCollator.compare(string, string2) : this.m_collator.compare(string, string2)))) : this.compareAsNumber(string, string2);
        if (!this.m_blnAscending) {
            n = 0 - n;
        }
        return n;
    }

    private int compareAsNumber(String string, String string2) {
        double d;
        double d2;
        try {
            d2 = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d2 = 0.0;
        }
        try {
            d = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        if (d2 < d) {
            return -1;
        }
        if (d2 == d) {
            return 0;
        }
        return 1;
    }

    private Locale getLocale() throws XSLException {
        Locale locale = Locale.getDefault();
        if (this.m_strLang == "") {
            return locale;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_strLang, "-");
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return new Locale(string, string2);
    }

    void handleLanguageCollator() throws XSLException {
        Locale locale = this.getLocale();
        String string = locale.getLanguage();
        if (string == null || string.length() == 0 || string.equals("en")) {
            this.m_blnIsEnglish = true;
        } else {
            this.m_collator = Collator.getInstance(locale);
            this.m_collator.setStrength(2);
            this.m_blnIsEnglish = false;
        }
    }

    private void fillRuleBaseTables(XSLTContext xSLTContext) throws XSLException {
        String string;
        String string2;
        if (this.m_intCaseOrder == 1 && this.m_blnAscending || this.m_intCaseOrder == 2 && !this.m_blnAscending) {
            string2 = " < ' ' < '!' < '\"' < '#' < '$' < '%' < '&' < ''' < '(' < ')' < '*' < '+' < ',' < '-' < '.' < '/' < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9 < ':' < ';' < '<' < '=' < '>' < '?' < '@' < A < a < B < b < C < c < D < d < E < e < F < f < G < g < H < h < I < i < J < j < K < k < L < l < M < m < N < n < O < o < P < p < Q < q < R < r < S < s < T < t < U < u < V < v < W < w < X < x < Y < y < Z < z < '[' < '\\' < ']' < '^' < '_' < '`'";
            string = UPPER_FIRST;
        } else if (this.m_intCaseOrder == 2 && this.m_blnAscending || this.m_intCaseOrder == 1 && !this.m_blnAscending) {
            string2 = " < ' ' < '!' < '\"' < '#' < '$' < '%' < '&' < ''' < '(' < ')' < '*' < '+' < ',' < '-' < '.' < '/' < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9 < ':' < ';' < '<' < '=' < '>' < '?' < '@' < a < A < b < B < c < C < d < D < e < E < f < F < g < G < h < H < i < I < j < J < k < K < l < L < m < M < n < N < o < O < p < P < q < Q < r < R < s < S < t < T < u < U < v < V < w < W < x < X < y < Y < z < Z  < '[' < '\\' < ']' < '^' < '_' < '`'";
            string = LOWER_FIRST;
        } else {
            string2 = " < ' ' < '!' < '\"' < '#' < '$' < '%' < '&' < ''' < '(' < ')' < '*' < '+' < ',' < '-' < '.' < '/' < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9 < ':' < ';' < '<' < '=' < '>' < '?' < '@' < A < B < C < D < E < F < G < H < I < J < K < L < M < N < O < P < Q < R < S < T < U < V < W < X < Y < Z < '[' < '\\' < ']' < '^' < '_' < '`' < a < b < c < d < e < f < g < h < i < j < k < l < m < n < o < p < q < r < s < t < u < v < w < x < y < z ";
            string = "no case-order";
        }
        try {
            this.m_usCollator = new RuleBasedCollator(string2);
        }
        catch (ParseException parseException) {
            XMLError xMLError = xSLTContext.getError();
            xMLError.error2(1030, 2, string, CASE_ORDER_ATTR);
        }
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        if (this.m_seckey != null) {
            this.m_seckey.finalizeXSLNode();
        }
        super.finalizeXSLNode();
    }

    @Override
    void printChildren(PrintWriter printWriter, int n) {
        if (this.m_seckey != null) {
            this.m_seckey.printXSLNode(printWriter, n);
        }
        super.printChildren(printWriter, n);
    }
}

