/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.services.docdb.model.KeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveTagsFromResourceRequest
extends DocDbRequest
implements ToCopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoveTagsFromResourceRequest.getter(RemoveTagsFromResourceRequest::resourceName)).setter(RemoveTagsFromResourceRequest.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RemoveTagsFromResourceRequest.getter(RemoveTagsFromResourceRequest::tagKeys)).setter(RemoveTagsFromResourceRequest.setter(Builder::tagKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD, TAG_KEYS_FIELD));
    private final String resourceName;
    private final List<String> tagKeys;

    private RemoveTagsFromResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.tagKeys = builder.tagKeys;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromResourceRequest)) {
            return false;
        }
        RemoveTagsFromResourceRequest other = (RemoveTagsFromResourceRequest)((Object)obj);
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.tagKeys(), other.tagKeys());
    }

    public String toString() {
        return ToString.builder((String)"RemoveTagsFromResourceRequest").add("ResourceName", (Object)this.resourceName()).add("TagKeys", this.tagKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "TagKeys": {
                return Optional.ofNullable(clazz.cast(this.tagKeys()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveTagsFromResourceRequest, T> g) {
        return obj -> g.apply((RemoveTagsFromResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbRequest.BuilderImpl
    implements Builder {
        private String resourceName;
        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsFromResourceRequest model) {
            super(model);
            this.resourceName(model.resourceName);
            this.tagKeys(model.tagKeys);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveTagsFromResourceRequest build() {
            return new RemoveTagsFromResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
        public Builder resourceName(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

