/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.exec;

import com.dbeaver.db.google.bigtable.exec.BigTableSession;
import com.dbeaver.db.google.bigtable.model.BigTableDataSource;
import com.dbeaver.db.google.bigtable.model.BigTableInstance;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class BigTableExecutionContext
extends AbstractExecutionContext<BigTableDataSource> {
    private static final Log log = Log.getLog(BigTableExecutionContext.class);
    private final BigTableInstance instance;

    public BigTableExecutionContext(BigTableInstance instance, String purpose) {
        super((DBPDataSource)instance.getDataSource(), purpose);
        this.instance = instance;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((BigTableDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open BigTableDB session");
                ((BigTableDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
                super.initContextBootstrap(monitor, true);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, this.dataSource);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((BigTableDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public BigTableSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new BigTableSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        try {
            this.instance.getDataSource().getInstanceAdminClient().listInstances();
        }
        catch (Exception e) {
            throw new DBException("Error pinging BigTable", (Throwable)e);
        }
    }

    public BigTableInstance getOwnerInstance() {
        return this.instance;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    public void close() {
        super.closeContext();
    }
}

