/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.application;

import com.dbeaver.ee.application.EnterpriseVersionUpdateDialog;
import com.dbeaver.ee.application.EnterpriseWorkbenchAdvisor;
import com.dbeaver.ee.runtime.core.DBeaverEnterpriseLM;
import com.dbeaver.ee.runtime.core.EnterpriseSecureStorage;
import com.dbeaver.lm.ui.LicenseUIUtils;
import java.io.File;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.application.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.core.application.DBeaverApplication;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMValidateException;

public class DBeaverEnterpriseApplication
extends DBeaverApplication {
    private static final Log log = Log.getLog(DBeaverEnterpriseApplication.class);
    private DBASecureStorage eeSecureStorage;

    protected void initializeApplication() {
        super.initializeApplication();
        String licenseFileName = ".dbeaver-ee-license.dat";
        File userLicenseFile = new File(System.getProperty("user.home"), licenseFileName);
        File workspaceLicenseFile = new File(GeneralUtils.getMetadataFolder(), licenseFileName);
        LMLicenseManager.addLicenseSearchPath((File)userLicenseFile);
        LMLicenseManager.addLicenseSearchPath((File)workspaceLicenseFile);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new EnterpriseWorkbenchAdvisor();
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        if (this.eeSecureStorage == null) {
            this.eeSecureStorage = new EnterpriseSecureStorage();
        }
        return this.eeSecureStorage;
    }

    public String getInfoDetails() {
        try {
            LMLicense license = DBeaverEnterpriseLM.LICENSE_MANAGER.getValidProductLicense(LicenseUIUtils.getClientId(), DBeaverEnterpriseLM.EE_PRODUCT, false);
            return "Licensed to " + license.getOwnerFull() + "\n" + "License ID: " + license.getLicenseId();
        }
        catch (LMValidateException e) {
            log.error((Object)"Error getting license information", (Throwable)e);
            return e.getMessage();
        }
    }

    public void notifyVersionUpgrade(VersionDescriptor versionDescriptor, boolean showSkip) {
        EnterpriseVersionUpdateDialog dialog = new EnterpriseVersionUpdateDialog(UIUtils.getActiveWorkbenchShell(), versionDescriptor, showSkip);
        dialog.open();
    }
}

