/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.application;

import com.dbeaver.ee.application.EnterpriseActionBarAdvisor;
import com.dbeaver.ee.runtime.core.DBeaverEnterpriseLM;
import com.dbeaver.ee.runtime.ui.LicenseManagerUIUtils;
import com.dbeaver.lm.ui.LicenseUIUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.core.application.ApplicationWorkbenchWindowAdvisor;
import org.jkiss.dbeaver.core.application.DBeaverCommandLine;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.lm.LMLicenseManager;

public class EnterpriseWorkbenchWindowAdvisor
extends ApplicationWorkbenchWindowAdvisor {
    private static final int RC_NOT_LICENSED = 100;

    public EnterpriseWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public void postWindowOpen() {
        UIUtils.asyncExec(() -> {
            boolean hasLicense = false;
            try {
                Shell shell = this.getWindowConfigurer().getWindow().getShell();
                hasLicense = LicenseManagerUIUtils.checkLicense((Shell)shell);
            }
            catch (Throwable e) {
                DBeaverUI.getInstance().showError("License check", "Error checking license information", e);
            }
            if (!hasLicense) {
                System.exit(100);
            }
        });
        super.postWindowOpen();
    }

    protected boolean isRunWorkbenchInitializers() {
        if (!DBeaverEnterpriseLM.hasLicense((String)LicenseUIUtils.getClientId())) {
            return false;
        }
        return super.isRunWorkbenchInitializers();
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new EnterpriseActionBarAdvisor(configurer);
    }

    public static class LicenseParameterHandler
    implements DBeaverCommandLine.ParameterHandler {
        public void handleParameter(String name, String value) {
            LMLicenseManager.setLicenseCustomPath((String)value);
        }
    }
}

