/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.ext;

import java.util.HashSet;
import java.util.Set;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Relation;

public class HanaDBDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "HDB";
    protected Set<String> systemViews = new HashSet<String>();

    public HanaDBDatabase() {
        this.systemViews.add("---");
        this.systemViews.add("AUDIT_POLICIES");
        this.systemViews.add("AUTHORIZATION_GRAPH");
        this.systemViews.add("CONSTRAINTS");
        this.systemViews.add("CS_BO_VIEWS");
        this.systemViews.add("CS_FREESTYLE_COLUMNS");
        this.systemViews.add("CS_JOIN_CONDITIONS");
        this.systemViews.add("CS_JOIN_CONSTRAINTS");
        this.systemViews.add("CS_JOIN_PATHS");
        this.systemViews.add("CS_JOIN_TABLES");
        this.systemViews.add("CS_KEY_FIGURES");
        this.systemViews.add("CS_VIEW_COLUMNS");
        this.systemViews.add("DATA_TYPES");
        this.systemViews.add("EFFECTIVE_PRIVILEGES");
        this.systemViews.add("EXPLAIN_PLAN_TABLE");
        this.systemViews.add("FULLTEXT_INDEXES");
        this.systemViews.add("FUNCTIONS");
        this.systemViews.add("FUNCTION_PARAMETERS");
        this.systemViews.add("GRANTED_PRIVILEGES");
        this.systemViews.add("GRANTED_ROLES");
        this.systemViews.add("INDEXES");
        this.systemViews.add("INDEX_COLUMNS");
        this.systemViews.add("INVALID_CONNECT_ATTEMPTS");
        this.systemViews.add("M_ATTACHED_STORAGES");
        this.systemViews.add("M_BACKUP_CATALOG");
        this.systemViews.add("M_BACKUP_CATALOG_FILES");
        this.systemViews.add("M_BACKUP_CONFIGURATION");
        this.systemViews.add("M_BLOCKED_TRANSACTIONS");
        this.systemViews.add("M_CACHES");
        this.systemViews.add("M_CACHES_RESET");
        this.systemViews.add("M_CACHE_ENTRIES");
        this.systemViews.add("M_CATALOG_MEMORY");
        this.systemViews.add("M_CE_CALCSCENARIOS");
        this.systemViews.add("M_CE_CALCVIEW_DEPENDENCIES");
        this.systemViews.add("M_CE_DEBUG_INFOS");
        this.systemViews.add("M_CE_DEBUG_JSONS");
        this.systemViews.add("M_CE_DEBUG_NODE_MAPPING");
        this.systemViews.add("M_CE_PLE_CALCSCENARIOS");
        this.systemViews.add("M_CLIENT_VERSIONS");
        this.systemViews.add("M_COMPACTION_THREAD");
        this.systemViews.add("M_CONDITIONAL_VARIABLES");
        this.systemViews.add("M_CONDITIONAL_VARIABLES_RESET");
        this.systemViews.add("M_CONFIGURATION");
        this.systemViews.add("M_CONNECTIONS");
        this.systemViews.add("M_CONNECTION_STATISTICS");
        this.systemViews.add("M_CONTAINER_DIRECTORY");
        this.systemViews.add("M_CONTAINER_NAME_DIRECTORY");
        this.systemViews.add("M_CONTEXT_MEMORY");
        this.systemViews.add("M_CONTEXT_MEMORY_RESET");
        this.systemViews.add("M_CONVERTER_STATISTICS");
        this.systemViews.add("M_CONVERTER_STATISTICS_RESET");
        this.systemViews.add("M_CS_ALL_COLUMNS");
        this.systemViews.add("M_CS_COLUMNS");
        this.systemViews.add("M_CS_PARTITIONS");
        this.systemViews.add("M_CS_TABLES");
        this.systemViews.add("M_CS_UNLOADS");
        this.systemViews.add("M_DATABASE");
        this.systemViews.add("M_DATABASE_HISTORY");
        this.systemViews.add("M_DATA_VOLUMES");
        this.systemViews.add("M_DATA_VOLUME_PAGE_STATISTICS");
        this.systemViews.add("M_DATA_VOLUME_PAGE_STATISTICS_RESET");
        this.systemViews.add("M_DATA_VOLUME_SUPERBLOCK_STATISTICS");
        this.systemViews.add("M_DELTA_MERGE_STATISTICS");
        this.systemViews.add("M_DISKS");
        this.systemViews.add("M_ERROR_CODES");
        this.systemViews.add("M_EVENTS");
        this.systemViews.add("M_EXPENSIVE_STATEMENTS");
        this.systemViews.add("M_EXPORT_BINARY_STATUS");
        this.systemViews.add("M_EXTRACTORS");
        this.systemViews.add("M_FEATURES");
        this.systemViews.add("M_FULLTEXT_QUEUES");
        this.systemViews.add("M_GARBAGE_COLLECTION_STATISTICS");
        this.systemViews.add("M_GARBAGE_COLLECTION_STATISTICS_RESET");
        this.systemViews.add("M_HEAP_MEMORY");
        this.systemViews.add("M_HEAP_MEMORY_RESET");
        this.systemViews.add("M_HISTORY_INDEX_LAST_COMMIT_ID");
        this.systemViews.add("M_HOST_INFORMATION");
        this.systemViews.add("M_HOST_RESOURCE_UTILIZATION");
        this.systemViews.add("M_IMPORT_BINARY_STATUS");
        this.systemViews.add("M_INIFILES");
        this.systemViews.add("M_INIFILE_CONTENTS");
        this.systemViews.add("M_JOB_PROGRESS");
        this.systemViews.add("M_LANDSCAPE_HOST_CONFIGURATION");
        this.systemViews.add("M_LICENSE");
        this.systemViews.add("M_LICENSE_USAGE_HISTORY");
        this.systemViews.add("M_LIVECACHE_CONTAINER_STATISTICS");
        this.systemViews.add("M_LIVECACHE_CONTAINER_STATISTICS_RESET");
        this.systemViews.add("M_LIVECACHE_LOCKS");
        this.systemViews.add("M_LIVECACHE_LOCK_STATISTICS");
        this.systemViews.add("M_LIVECACHE_LOCK_STATISTICS_RESET");
        this.systemViews.add("M_LIVECACHE_OMS_VERSIONS");
        this.systemViews.add("M_LIVECACHE_PROCEDURE_STATISTICS");
        this.systemViews.add("M_LIVECACHE_PROCEDURE_STATISTICS_RESET");
        this.systemViews.add("M_LIVECACHE_SCHEMA_STATISTICS");
        this.systemViews.add("M_LIVECACHE_SCHEMA_STATISTICS_RESET");
        this.systemViews.add("M_LOCK_WAITS_STATISTICS");
        this.systemViews.add("M_LOG_BUFFERS");
        this.systemViews.add("M_LOG_BUFFERS_RESET");
        this.systemViews.add("M_LOG_PARTITIONS");
        this.systemViews.add("M_LOG_PARTITIONS_RESET");
        this.systemViews.add("M_LOG_SEGMENTS");
        this.systemViews.add("M_LOG_SEGMENTS_RESET");
        this.systemViews.add("M_MEMORY_OBJECTS");
        this.systemViews.add("M_MEMORY_OBJECTS_RESET");
        this.systemViews.add("M_MEMORY_OBJECT_DISPOSITIONS");
        this.systemViews.add("M_MERGED_TRACES");
        this.systemViews.add("M_MONITORS");
        this.systemViews.add("M_MONITOR_COLUMNS");
        this.systemViews.add("M_MUTEXES");
        this.systemViews.add("M_MUTEXES_RESET");
        this.systemViews.add("M_MVCC_TABLES");
        this.systemViews.add("M_OBJECT_LOCKS");
        this.systemViews.add("M_OBJECT_LOCK_STATISTICS");
        this.systemViews.add("M_OBJECT_LOCK_STATISTICS_RESET");
        this.systemViews.add("M_PAGEACCESS_STATISTICS");
        this.systemViews.add("M_PAGEACCESS_STATISTICS_RESET");
        this.systemViews.add("M_PASSWORD_POLICY");
        this.systemViews.add("M_PERFTRACE");
        this.systemViews.add("M_PERSISTENCE_MANAGERS");
        this.systemViews.add("M_PERSISTENCE_MANAGERS_RESET");
        this.systemViews.add("M_PREPARED_STATEMENTS");
        this.systemViews.add("M_READWRITELOCKS");
        this.systemViews.add("M_READWRITELOCKS_RESET");
        this.systemViews.add("M_RECORD_LOCKS");
        this.systemViews.add("M_REORG_ALGORITHMS");
        this.systemViews.add("M_REPO_TRANSPORT_FILES");
        this.systemViews.add("M_RS_INDEXES");
        this.systemViews.add("M_RS_TABLES");
        this.systemViews.add("M_RS_TABLE_VERSION_STATISTICS");
        this.systemViews.add("M_SAVEPOINTS");
        this.systemViews.add("M_SAVEPOINT_STATISTICS");
        this.systemViews.add("M_SAVEPOINT_STATISTICS_RESET");
        this.systemViews.add("M_SEMAPHORES");
        this.systemViews.add("M_SEMAPHORES_RESET");
        this.systemViews.add("M_SERVICES");
        this.systemViews.add("M_SERVICE_COMPONENT_MEMORY");
        this.systemViews.add("M_SERVICE_MEMORY");
        this.systemViews.add("M_SERVICE_NETWORK_IO");
        this.systemViews.add("M_SERVICE_REPLICATION");
        this.systemViews.add("M_SERVICE_STATISTICS");
        this.systemViews.add("M_SERVICE_THREADS");
        this.systemViews.add("M_SERVICE_THREAD_CALLSTACKS");
        this.systemViews.add("M_SERVICE_TRACES");
        this.systemViews.add("M_SERVICE_TYPES");
        this.systemViews.add("M_SESSION_CONTEXT");
        this.systemViews.add("M_SHARED_MEMORY");
        this.systemViews.add("M_SNAPSHOTS");
        this.systemViews.add("M_SQL_PLAN_CACHE");
        this.systemViews.add("M_SQL_PLAN_CACHE_OVERVIEW");
        this.systemViews.add("M_SQL_PLAN_CACHE_RESET");
        this.systemViews.add("M_SYSTEM_INFORMATION_STATEMENTS");
        this.systemViews.add("M_SYSTEM_LIMITS");
        this.systemViews.add("M_SYSTEM_OVERVIEW");
        this.systemViews.add("M_TABLES");
        this.systemViews.add("M_TABLE_LOB_FILES");
        this.systemViews.add("M_TABLE_LOCATIONS");
        this.systemViews.add("M_TABLE_PERSISTENCE_LOCATIONS");
        this.systemViews.add("M_TABLE_PERSISTENCE_STATISTICS");
        this.systemViews.add("M_TABLE_VIRTUAL_FILES");
        this.systemViews.add("M_TEMPORARY_TABLES");
        this.systemViews.add("M_TEMPORARY_TABLE_COLUMNS");
        this.systemViews.add("M_TEMPORARY_VIEWS");
        this.systemViews.add("M_TEMPORARY_VIEW_COLUMNS");
        this.systemViews.add("M_TENANTS");
        this.systemViews.add("M_TEXT_ANALYSIS_LANGUAGES");
        this.systemViews.add("M_TEXT_ANALYSIS_MIME_TYPES");
        this.systemViews.add("M_TOPOLOGY_TREE");
        this.systemViews.add("M_TRACEFILES");
        this.systemViews.add("M_TRACEFILE_CONTENTS");
        this.systemViews.add("M_TRANSACTIONS");
        this.systemViews.add("M_UNDO_CLEANUP_FILES");
        this.systemViews.add("M_VERSION_MEMORY");
        this.systemViews.add("M_VOLUMES");
        this.systemViews.add("M_VOLUME_FILES");
        this.systemViews.add("M_VOLUME_IO_PERFORMANCE_STATISTICS");
        this.systemViews.add("M_VOLUME_IO_PERFORMANCE_STATISTICS_RESET");
        this.systemViews.add("M_VOLUME_IO_STATISTICS");
        this.systemViews.add("M_VOLUME_IO_STATISTICS_RESET");
        this.systemViews.add("M_VOLUME_SIZES");
        this.systemViews.add("M_WORKLOAD");
        this.systemViews.add("M_XS_APPLICATIONS");
        this.systemViews.add("M_XS_APPLICATION_ISSUES");
        this.systemViews.add("OBJECTS");
        this.systemViews.add("OBJECT_DEPENDENCIES");
        this.systemViews.add("OWNERSHIP");
        this.systemViews.add("PRIVILEGES");
        this.systemViews.add("PROCEDURES");
        this.systemViews.add("PROCEDURE_OBJECTS");
        this.systemViews.add("PROCEDURE_PARAMETERS");
        this.systemViews.add("QUERY_PLANS");
        this.systemViews.add("REFERENTIAL_CONSTRAINTS");
        this.systemViews.add("REORG_OVERVIEW");
        this.systemViews.add("REORG_PLAN");
        this.systemViews.add("REORG_PLAN_INFOS");
        this.systemViews.add("REORG_STEPS");
        this.systemViews.add("ROLES");
        this.systemViews.add("SAML_PROVIDERS");
        this.systemViews.add("SAML_USER_MAPPINGS");
        this.systemViews.add("SCHEMAS");
        this.systemViews.add("SEQUENCES");
        this.systemViews.add("SQLSCRIPT_TRACE");
        this.systemViews.add("STATISTICS");
        this.systemViews.add("STRUCTURED_PRIVILEGES");
        this.systemViews.add("SYNONYMS");
        this.systemViews.add("TABLES");
        this.systemViews.add("TABLE_COLUMNS");
        this.systemViews.add("TABLE_COLUMNS_ODBC");
        this.systemViews.add("TABLE_GROUPS");
        this.systemViews.add("TRANSACTION_HISTORY");
        this.systemViews.add("TRIGGERS");
        this.systemViews.add("USERS");
        this.systemViews.add("USER_PARAMETERS");
        this.systemViews.add("VIEWS");
        this.systemViews.add("VIEW_COLUMNS");
        this.systemViews.add("GLOBAL_COLUMN_TABLES_SIZE");
        this.systemViews.add("GLOBAL_CPU_STATISTICS");
        this.systemViews.add("GLOBAL_INTERNAL_DISKFULL_EVENTS");
        this.systemViews.add("GLOBAL_INTERNAL_EVENTS");
        this.systemViews.add("GLOBAL_MEMORY_STATISTICS");
        this.systemViews.add("GLOBAL_PERSISTENCE_STATISTICS");
        this.systemViews.add("GLOBAL_TABLES_SIZE");
        this.systemViews.add("HOST_BLOCKED_TRANSACTIONS");
        this.systemViews.add("HOST_COLUMN_TABLES_PART_SIZE");
        this.systemViews.add("HOST_DATA_VOLUME_PAGE_STATISTICS");
        this.systemViews.add("HOST_DATA_VOLUME_SUPERBLOCK_STATISTICS");
        this.systemViews.add("HOST_DELTA_MERGE_STATISTICS");
        this.systemViews.add("HOST_HEAP_ALLOCATORS");
        this.systemViews.add("HOST_LONG_RUNNING_STATEMENTS");
        this.systemViews.add("HOST_MEMORY_STATISTICS");
        this.systemViews.add("HOST_ONE_DAY_FILE_COUNT");
        this.systemViews.add("HOST_RESOURCE_UTILIZATION_STATISTICS");
        this.systemViews.add("HOST_SERVICE_MEMORY");
        this.systemViews.add("HOST_SERVICE_STATISTICS");
        this.systemViews.add("HOST_TABLE_VIRTUAL_FILES");
        this.systemViews.add("HOST_VIRTUAL_FILES");
        this.systemViews.add("HOST_VOLUME_FILES");
        this.systemViews.add("HOST_VOLUME_IO_PERFORMANCE_STATISTICS");
        this.systemViews.add("HOST_VOLUME_IO_STATISTICS");
        this.systemViews.add("STATISTICS_ALERTS");
        this.systemViews.add("STATISTICS_ALERT_INFORMATION");
        this.systemViews.add("STATISTICS_ALERT_LAST_CHECK_INFORMATION");
        this.systemViews.add("STATISTICS_INTERVAL_INFORMATION");
        this.systemViews.add("STATISTICS_LASTVALUES");
        this.systemViews.add("STATISTICS_STATE");
        this.systemViews.add("STATISTICS_VERSION");
        this.systemViews.add("STATISTICS_ALERTS");
    }

    public int getPriority() {
        return 5;
    }

    protected String getDefaultDatabaseProductName() {
        return "HANA DB";
    }

    public Integer getDefaultPort() {
        return 30015;
    }

    public Set<String> getSystemViews() {
        return this.systemViews;
    }

    public String getShortName() {
        return "hanadb";
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sapdb")) {
            return "com.sap.db.jdbc.Driver";
        }
        return null;
    }

    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "CURRENT_TIMESTAMP";
    }

    public String getDefaultSchemaName() {
        return super.getDefaultSchemaName().toUpperCase();
    }

    public boolean isSystemObject(DatabaseObject example) {
        if (super.isSystemObject(example)) {
            return true;
        }
        if (example instanceof Relation) {
            String schemaName = example.getSchema().getName();
            if ("_SYS_SECURITY".equalsIgnoreCase(schemaName)) {
                return true;
            }
            if ("_SYS_REPO".equalsIgnoreCase(schemaName)) {
                return true;
            }
            if ("_SYS_STATISTICS".equalsIgnoreCase(schemaName)) {
                return true;
            }
        }
        return false;
    }

    public boolean supportsTablespaces() {
        return true;
    }

    public boolean supportsAutoIncrement() {
        return false;
    }
}

