/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.jdbc;

import java.sql.SQLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.debug.DBGEvent;
import org.jkiss.dbeaver.debug.jdbc.DBGJDBCSession;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DBGJDBCWorker
extends AbstractJob {
    private final DBGJDBCSession debugSession;
    private final String sql;
    private final DBGEvent before;
    private final DBGEvent after;

    public DBGJDBCWorker(DBGJDBCSession debugSession, String name, String sqlCommand, DBGEvent begin, DBGEvent end) {
        super(name);
        this.debugSession = debugSession;
        this.sql = sqlCommand;
        this.before = begin;
        this.after = end;
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        monitor.beginTask("Execute debug job", 1);
        try {
            IStatus iStatus;
            JDBCSession session;
            block27: {
                Throwable throwable = null;
                Object var3_5 = null;
                session = this.debugSession.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Run debug job");
                monitor.subTask(this.sql);
                Throwable throwable2 = null;
                Object var6_10 = null;
                JDBCStatement stmt = session.createStatement();
                try {
                    this.debugSession.fireEvent(this.before);
                    stmt.execute(this.sql);
                    this.debugSession.fireEvent(this.after);
                    iStatus = Status.OK_STATUS;
                    if (stmt == null) break block27;
                }
                catch (Throwable throwable3) {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable5) {
                            try {
                                if (session != null) {
                                    session.close();
                                }
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                try {
                                    if (throwable == null) {
                                        throwable = throwable6;
                                    } else if (throwable != throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    throw throwable;
                                }
                                catch (SQLException e) {
                                    iStatus = GeneralUtils.makeExceptionStatus((String)String.format("Failed to execute %s", this.sql), (Throwable)e);
                                    return iStatus;
                                }
                            }
                        }
                    }
                }
                stmt.close();
            }
            if (session != null) {
                session.close();
            }
            monitor.done();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

