/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.adv.generator;

import com.dbeaver.ee.mockdata.adv.generator.NumericAdvancedGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringAddressGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringCityGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringCountryGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringDomainGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringEmailGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringNameGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringRegexGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mockdata.generator.AbstractStringValueGenerator;
import org.jkiss.dbeaver.ext.mockdata.generator.ConstantGenerator;
import org.jkiss.dbeaver.ext.mockdata.generator.NumericSequenceGenerator;
import org.jkiss.dbeaver.ext.mockdata.model.MockValueGenerator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.utils.CommonUtils;

public class StringTemplateGenerator
extends AbstractStringValueGenerator {
    private static final Log log = Log.getLog(StringTemplateGenerator.class);
    private String template;
    private List<MockValueGenerator> generatorsSequence = new ArrayList<MockValueGenerator>();

    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        String[] tokens;
        super.init(container, attribute, properties);
        String template = (String)properties.get("template");
        if (!CommonUtils.isEmpty((String)template)) {
            this.template = template;
        }
        String[] stringArray = tokens = CommonUtils.splitWithDelimiter((String)this.template, (String)"${");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            block37: {
                boolean flag;
                String token;
                block38: {
                    boolean hasParameters;
                    int index;
                    token = stringArray[n2];
                    if (CommonUtils.isEmpty((String)token)) break block37;
                    flag = true;
                    if (!token.startsWith("${") || (index = token.lastIndexOf(125)) <= 0) break block38;
                    String generatorMarker = token.substring(2, index);
                    int firstBracketIndex = generatorMarker.indexOf(40);
                    int lastBracketIndex = generatorMarker.lastIndexOf(41);
                    boolean bl = hasParameters = firstBracketIndex > 0 && lastBracketIndex > firstBracketIndex;
                    if (!hasParameters) break block38;
                    try {
                        String generatorName;
                        String[] generatorParameters = generatorMarker.substring(firstBracketIndex + 1, lastBracketIndex).split(",");
                        switch (generatorName = generatorMarker.substring(0, firstBracketIndex)) {
                            case "address": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringAddressGenerator(), container, new Object[0]));
                                break;
                            }
                            case "city": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringCityGenerator(), container, new Object[0]));
                                break;
                            }
                            case "country": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringCountryGenerator(), container, new Object[0]));
                                break;
                            }
                            case "domain": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringDomainGenerator(), container, new Object[0]));
                                break;
                            }
                            case "email": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringEmailGenerator(), container, "gender", generatorParameters[0], "withSurnames", generatorParameters[1], "numericSuffixSize", 0));
                                break;
                            }
                            case "name": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringNameGenerator(), container, "gender", generatorParameters[0], "withSurnames", generatorParameters[1]));
                                break;
                            }
                            case "random": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new NumericAdvancedGenerator(), container, "minimum", generatorParameters[0], "maximum", generatorParameters[1], "precision", 10, "scale", 0));
                                break;
                            }
                            case "regex": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringRegexGenerator(), container, "regex", generatorParameters[0]));
                                break;
                            }
                            case "sequence": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new NumericSequenceGenerator(), container, "start", generatorParameters[0], "step", generatorParameters[1]));
                            }
                        }
                        String theRest = token.substring(index + 1);
                        if (!CommonUtils.isEmpty((String)theRest)) {
                            this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new ConstantGenerator(), container, "value", theRest));
                        }
                        flag = false;
                    }
                    catch (Exception e) {
                        String message = "Error of the \"" + token + "\" directive of the \"" + template + "\" template processing.";
                        log.error((Object)message, (Throwable)e);
                        throw new DBException(message);
                    }
                }
                if (flag) {
                    this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new ConstantGenerator(), container, "value", token));
                }
            }
            ++n2;
        }
    }

    protected Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        StringBuilder sb = new StringBuilder();
        for (MockValueGenerator generator : this.generatorsSequence) {
            sb.append(generator.generateValue(monitor));
        }
        return sb.toString();
    }

    private MockValueGenerator initGenerator(MockValueGenerator generator, DBSDataManipulator container, Object ... args) throws DBException {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        Iterator<Object> iterator = Arrays.asList(args).iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = iterator.next();
            properties.put(key, value);
        }
        properties.put("nulls", 0);
        generator.init(container, this.attribute, properties);
        return generator;
    }
}

