/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.adv.generator;

import java.io.IOException;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mockdata.MockDataUtils;
import org.jkiss.dbeaver.ext.mockdata.generator.AbstractMockValueGenerator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.utils.CommonUtils;

public class NumericAdvancedGenerator
extends AbstractMockValueGenerator {
    private Double min;
    private Double max;
    private Integer precision;
    private Integer scale;

    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        Object s;
        Object p;
        super.init(container, attribute, properties);
        Double d = this.getDoubleProperty(properties, "minimum");
        if (d != null) {
            this.min = d;
        }
        if ((d = this.getDoubleProperty(properties, "maximum")) != null) {
            this.max = d;
        }
        if ((p = properties.get("precision")) != null) {
            this.precision = CommonUtils.toInt((Object)p);
        }
        if ((s = properties.get("scale")) != null) {
            this.scale = CommonUtils.toInt((Object)s);
        }
    }

    protected Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        Integer attrScale = this.attribute.getScale();
        if (this.scale != null) {
            if (attrScale == null) {
                attrScale = this.scale;
            } else if (attrScale > this.scale) {
                attrScale = this.scale;
            }
        }
        Integer attrPrecision = this.attribute.getPrecision();
        if (this.precision != null) {
            if (attrPrecision == null) {
                attrPrecision = this.precision;
            } else if (attrPrecision > this.precision) {
                attrPrecision = this.precision;
            }
        }
        return MockDataUtils.generateNumeric((Integer)attrPrecision, (Integer)attrScale, (Double)this.min, (Double)this.max);
    }
}

