/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import com.dbeaver.ee.influxdb.model.InfluxDataType;
import com.dbeaver.ee.influxdb.model.InfluxMeasurement;
import java.util.ArrayList;
import java.util.List;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public class InfluxMeasurementTag
implements DBSTableColumn,
DBPRefreshableObject {
    private static final Log log = Log.getLog(InfluxMeasurementTag.class);
    private final InfluxMeasurement table;
    private String name;
    private int position;
    private List<String> values;

    public InfluxMeasurementTag(InfluxMeasurement table, int position, String name) {
        this.table = table;
        this.position = position;
        this.name = name;
    }

    @NotNull
    public InfluxDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return true;
    }

    public int getOrdinalPosition() {
        return this.position;
    }

    public int getTypeID() {
        return InfluxDataType.TypeName.STRING.getTypeId();
    }

    public DBPDataKind getDataKind() {
        return InfluxDataType.TypeName.STRING.getDataKind();
    }

    public String getTypeName() {
        return InfluxDataType.TypeName.STRING.getTypeName();
    }

    public String getFullTypeName() {
        return InfluxDataType.TypeName.STRING.getTypeName();
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @NotNull
    public InfluxMeasurement getParentObject() {
        return this.table;
    }

    public String getDefaultValue() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public Integer getScale() {
        return 0;
    }

    public Integer getPrecision() {
        return 0;
    }

    public long getMaxLength() {
        return 0L;
    }

    public String toString() {
        return this.name;
    }

    @Property(viewable=true, editable=true, order=3)
    @Association
    public List<String> getTagValues(DBRProgressMonitor monitor) throws DBCException {
        if (this.values == null) {
            ArrayList<String> resList = new ArrayList<String>();
            InfluxDB influxDB = this.getDataSource().getDefaultContext(true).getInfluxDB();
            QueryResult dbListResult = influxDB.query(new Query("SHOW TAG VALUES FROM " + this.getParentObject().getName() + " WITH KEY = \"" + this.getName() + "\"", this.getParentObject().getDatabase().getName()));
            for (QueryResult.Result result : dbListResult.getResults()) {
                for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                    for (List dbObj : CommonUtils.safeList((List)series.getValues())) {
                        Object fieldName = dbObj.size() == 1 ? dbObj.get(0) : dbObj.get(1);
                        resList.add(CommonUtils.toString(fieldName));
                    }
                }
            }
            this.values = resList;
        }
        return this.values;
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        this.values = null;
        return this;
    }
}

