/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreOperatorClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreOperatorFamily;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreAccessMethod
extends PostgreInformation {
    public static final String CAT_ROUTINES = "Routines";
    public static final String CAT_FLAGS = "Flags";
    private long oid;
    private String name;
    private String handler;
    private String type;
    private int operatorStrategies;
    private int supportRoutines;
    private boolean canOrder;
    private boolean canOrderByOp;
    private boolean canBackward;
    private boolean canUnique;
    private boolean canMultiCol;
    private boolean optionalKey;
    private boolean searchArray;
    private boolean searchNulls;
    private boolean storage;
    private boolean clusterable;
    private boolean predLocks;
    private OperatorFamilyCache operatorFamilyCache = new OperatorFamilyCache();
    private OperatorClassCache operatorClassCache = new OperatorClassCache();

    public PostgreAccessMethod(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        super(database);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"amname");
        if (this.getDataSource().isServerVersionAtLeast(9, 6)) {
            this.handler = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"amhandler");
            this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"amtype");
        } else {
            this.operatorStrategies = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"amstrategies");
            this.supportRoutines = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"amsupport");
            this.canOrder = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amcanorder");
            this.canOrderByOp = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amcanorderbyop");
            this.canBackward = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amcanbackward");
            this.canUnique = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amcanunique");
            this.canMultiCol = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amcanmulticol");
            this.optionalKey = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amoptionalkey");
            this.searchArray = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amsearcharray");
            this.searchNulls = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amsearchnulls");
            this.storage = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amstorage");
            this.clusterable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"amclusterable");
            this.predLocks = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"ampredlocks");
        }
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=3)
    public String getHandler() {
        return this.handler;
    }

    @Property(viewable=true, order=4)
    public String getType() {
        return this.type;
    }

    @Property(category="Routines", order=100)
    public int getOperatorStrategies() {
        return this.operatorStrategies;
    }

    @Property(category="Routines", order=101)
    public int getSupportRoutines() {
        return this.supportRoutines;
    }

    @Property(category="Flags", order=200)
    public boolean isCanOrder() {
        return this.canOrder;
    }

    @Property(category="Flags", order=201)
    public boolean isCanOrderByOp() {
        return this.canOrderByOp;
    }

    @Property(category="Flags", order=202)
    public boolean isCanBackward() {
        return this.canBackward;
    }

    @Property(category="Flags", order=203)
    public boolean isCanUnique() {
        return this.canUnique;
    }

    @Property(category="Flags", order=204)
    public boolean isCanMultiCol() {
        return this.canMultiCol;
    }

    @Property(category="Flags", order=205)
    public boolean isOptionalKey() {
        return this.optionalKey;
    }

    @Property(category="Flags", order=206)
    public boolean isSearchArray() {
        return this.searchArray;
    }

    @Property(category="Flags", order=207)
    public boolean isSearchNulls() {
        return this.searchNulls;
    }

    @Property(category="Flags", order=208)
    public boolean isStorage() {
        return this.storage;
    }

    @Property(category="Flags", order=209)
    public boolean isClusterable() {
        return this.clusterable;
    }

    @Property(category="Flags", order=210)
    public boolean isPredLocks() {
        return this.predLocks;
    }

    @Association
    public Collection<PostgreOperatorClass> getOperatorClasses(DBRProgressMonitor monitor) throws DBException {
        return this.operatorClassCache.getAllObjects(monitor, this);
    }

    public PostgreOperatorClass getOperatorClass(DBRProgressMonitor monitor, long oid) throws DBException {
        return (PostgreOperatorClass)PostgreUtils.getObjectById(monitor, this.operatorClassCache, this, oid);
    }

    @Association
    public Collection<PostgreOperatorFamily> getOperatorFamilies(DBRProgressMonitor monitor) throws DBException {
        return this.operatorFamilyCache.getAllObjects(monitor, this);
    }

    public PostgreOperatorFamily getOperatorFamily(DBRProgressMonitor monitor, long oid) throws DBException {
        return (PostgreOperatorFamily)PostgreUtils.getObjectById(monitor, this.operatorFamilyCache, this, oid);
    }

    static class OperatorClassCache
    extends JDBCObjectCache<PostgreAccessMethod, PostgreOperatorClass> {
        OperatorClassCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreAccessMethod owner) throws SQLException {
            return session.prepareStatement("SELECT oc.oid,oc.* FROM pg_catalog.pg_opclass oc \nORDER BY oc.oid");
        }

        protected PostgreOperatorClass fetchObject(@NotNull JDBCSession session, @NotNull PostgreAccessMethod owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreOperatorClass(owner, (ResultSet)dbResult);
        }
    }

    static class OperatorFamilyCache
    extends JDBCObjectCache<PostgreAccessMethod, PostgreOperatorFamily> {
        OperatorFamilyCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreAccessMethod owner) throws SQLException {
            return session.prepareStatement("SELECT of.oid,of.* FROM pg_catalog.pg_opfamily of \nORDER BY of.oid");
        }

        protected PostgreOperatorFamily fetchObject(@NotNull JDBCSession session, @NotNull PostgreAccessMethod owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreOperatorFamily(owner, (ResultSet)dbResult);
        }
    }
}

