/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.IDataSourceContainerProviderEx;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPRegistryListener;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.ui.AbstractPartListener;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractPageListener;
import org.jkiss.dbeaver.ui.controls.CSmartSelector;
import org.jkiss.dbeaver.ui.controls.DatabaseLabelProviders;
import org.jkiss.dbeaver.ui.controls.SelectDataSourceCombo;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDatabaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

@Deprecated
public class DataSourceManagementToolbar
implements DBPRegistryListener,
DBPEventListener,
DBPPreferenceListener,
INavigatorListener {
    private static final Log log = Log.getLog(DataSourceManagementToolbar.class);
    private static DataSourceManagementToolbar toolBarInstance;
    private IWorkbenchWindow workbenchWindow;
    private IWorkbenchPart activePart;
    private IPageListener pageListener;
    private IPartListener partListener;
    private Text resultSetSize;
    private SelectDataSourceCombo connectionCombo;
    private CSmartSelector<DBNDatabaseNode> databaseCombo;
    private SoftReference<DBPDataSourceContainer> curDataSourceContainer = null;
    private final List<DBPDataSourceRegistry> handledRegistries = new ArrayList<DBPDataSourceRegistry>();
    private final List<DatabaseListReader> dbListReads = new ArrayList<DatabaseListReader>();
    private volatile IFile activeFile;
    private volatile String currentDatabaseInstanceName;

    public static DataSourceManagementToolbar getInstance() {
        return toolBarInstance;
    }

    public DataSourceManagementToolbar(IWorkbenchWindow workbenchWindow) {
        toolBarInstance = this;
        this.workbenchWindow = workbenchWindow;
        DBWorkbench.getPlatform().getNavigatorModel().addListener((INavigatorListener)this);
        final ISelectionListener selectionListener = (part, selection) -> {
            Object element;
            if (part == this.activePart && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && RuntimeUtils.getObjectAdapter((Object)element, DBSObject.class) != null) {
                this.updateControls(false);
            }
        };
        this.pageListener = new AbstractPageListener(){

            @Override
            public void pageClosed(IWorkbenchPage page) {
                page.removePartListener(DataSourceManagementToolbar.this.partListener);
                page.removeSelectionListener(selectionListener);
            }

            @Override
            public void pageOpened(IWorkbenchPage page) {
                page.addPartListener(DataSourceManagementToolbar.this.partListener);
                page.addSelectionListener(selectionListener);
            }
        };
        this.partListener = new AbstractPartListener(){

            public void partActivated(IWorkbenchPart part) {
                DataSourceManagementToolbar.this.setActivePart(part);
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == DataSourceManagementToolbar.this.activePart) {
                    DataSourceManagementToolbar.this.setActivePart(null);
                }
            }
        };
    }

    public void showConnectionSelector() {
        this.connectionCombo.showConnectionSelector();
    }

    private void dispose() {
        DBWorkbench.getPlatform().getNavigatorModel().removeListener((INavigatorListener)this);
        IWorkbenchPage activePage = this.workbenchWindow.getActivePage();
        if (activePage != null) {
            this.pageListener.pageClosed(activePage);
        }
        DataSourceProviderRegistry.getInstance().removeDataSourceRegistryListener((DBPRegistryListener)this);
        for (DBPDataSourceRegistry registry : this.handledRegistries) {
            registry.removeDataSourceListener((DBPEventListener)this);
        }
        this.setActivePart(null);
        this.workbenchWindow.removePageListener(this.pageListener);
    }

    public void handleRegistryLoad(DBPDataSourceRegistry registry) {
        registry.addDataSourceListener((DBPEventListener)this);
        this.handledRegistries.add(registry);
    }

    public void handleRegistryUnload(DBPDataSourceRegistry registry) {
        this.handledRegistries.remove(registry);
        registry.removeDataSourceListener((DBPEventListener)this);
    }

    @Nullable
    private static IAdaptable getActiveObject(IWorkbenchPart activePart) {
        if (activePart instanceof IEditorPart) {
            return ((IEditorPart)activePart).getEditorInput();
        }
        if (activePart instanceof IViewPart) {
            return activePart;
        }
        return null;
    }

    @Nullable
    private DBPDataSourceContainer getDataSourceContainer() {
        return DataSourceManagementToolbar.getDataSourceContainer(this.activePart);
    }

    @Nullable
    private static DBPDataSourceContainer getDataSourceContainer(IWorkbenchPart part) {
        DBCExecutionContext executionContext;
        if (part == null) {
            return null;
        }
        if (part instanceof IDataSourceContainerProvider) {
            return ((IDataSourceContainerProvider)part).getDataSourceContainer();
        }
        IAdaptable activeObject = DataSourceManagementToolbar.getActiveObject(part);
        if (activeObject == null) {
            return null;
        }
        if (activeObject instanceof IDataSourceContainerProvider) {
            return ((IDataSourceContainerProvider)activeObject).getDataSourceContainer();
        }
        if (activeObject instanceof DBPContextProvider && (executionContext = ((DBPContextProvider)activeObject).getExecutionContext()) != null) {
            return executionContext.getDataSource().getContainer();
        }
        return null;
    }

    @Nullable
    private IDataSourceContainerProviderEx getActiveDataSourceUpdater() {
        if (this.activePart instanceof IDataSourceContainerProviderEx) {
            return (IDataSourceContainerProviderEx)this.activePart;
        }
        IAdaptable activeObject = DataSourceManagementToolbar.getActiveObject(this.activePart);
        if (activeObject == null) {
            return null;
        }
        return activeObject instanceof IDataSourceContainerProviderEx ? (IDataSourceContainerProviderEx)activeObject : null;
    }

    private List<? extends DBPDataSourceContainer> getAvailableDataSources() {
        DBPDataSourceContainer dataSourceContainer;
        IFile curFile;
        IEditorPart activeEditor;
        if (this.workbenchWindow != null && this.workbenchWindow.getActivePage() != null && (activeEditor = this.workbenchWindow.getActivePage().getActiveEditor()) != null && activeEditor.getEditorInput() instanceof IFileEditorInput && (curFile = ((IFileEditorInput)activeEditor.getEditorInput()).getFile()) != null) {
            DBPDataSourceContainer fileDataSource = EditorUtils.getFileDataSource((IFile)curFile);
            if (fileDataSource != null) {
                return fileDataSource.getRegistry().getDataSources();
            }
            DBPDataSourceRegistry dsRegistry = DBWorkbench.getPlatform().getProjectManager().getDataSourceRegistry(curFile.getProject());
            if (dsRegistry != null) {
                return dsRegistry.getDataSources();
            }
        }
        if ((dataSourceContainer = this.getDataSourceContainer()) != null) {
            return dataSourceContainer.getRegistry().getDataSources();
        }
        return DataSourceRegistry.getAllDataSources();
    }

    private IProject getActiveProject() {
        IFile curFile;
        IEditorPart activeEditor;
        if (this.workbenchWindow != null && this.workbenchWindow.getActivePage() != null && (activeEditor = this.workbenchWindow.getActivePage().getActiveEditor()) != null && activeEditor.getEditorInput() instanceof IFileEditorInput && (curFile = ((IFileEditorInput)activeEditor.getEditorInput()).getFile()) != null) {
            return curFile.getProject();
        }
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (dataSourceContainer != null) {
            return dataSourceContainer.getRegistry().getProject();
        }
        return DBWorkbench.getPlatform().getProjectManager().getActiveProject();
    }

    public void setActivePart(@Nullable IWorkbenchPart part) {
        if (!(part instanceof IEditorPart)) {
            part = part == null || part.getSite() == null || part.getSite().getPage() == null ? null : part.getSite().getPage().getActiveEditor();
        }
        if (this.connectionCombo != null && !this.connectionCombo.isDisposed()) {
            int selConnection = this.connectionCombo.getSelectionIndex();
            DBPDataSourceContainer visibleContainer = null;
            if (selConnection > 0) {
                visibleContainer = (DBPDataSourceContainer)this.connectionCombo.getItem(selConnection);
            }
            DBPDataSourceContainer newContainer = DataSourceManagementToolbar.getDataSourceContainer(part);
            if (this.activePart != part || this.activePart == null || visibleContainer != newContainer) {
                DBPDataSourceContainer oldContainer = DataSourceManagementToolbar.getDataSourceContainer(this.activePart);
                this.activePart = part;
                if (oldContainer != newContainer) {
                    if (oldContainer != null) {
                        oldContainer.getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
                    }
                    if ((oldContainer = this.getDataSourceContainer()) != null) {
                        oldContainer.getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
                    }
                }
                this.updateControls(true);
            }
        }
        if (part != null) {
            IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
            this.activeFile = EditorUtils.getFileFromInput((IEditorInput)editorInput);
        } else {
            this.activeFile = null;
        }
    }

    private void fillDataSourceList(boolean force) {
        if (this.connectionCombo.isDisposed()) {
            return;
        }
        List<? extends DBPDataSourceContainer> dataSources = this.getAvailableDataSources();
        boolean update = force;
        if (!update) {
            ArrayList oldDataSources = new ArrayList(this.connectionCombo.getItems());
            if (oldDataSources.size() == dataSources.size()) {
                int i = 0;
                while (i < dataSources.size()) {
                    if (dataSources.get(i) != oldDataSources.get(i)) {
                        update = true;
                        break;
                    }
                    ++i;
                }
            } else {
                update = true;
            }
        }
        if (update) {
            this.connectionCombo.setRedraw(false);
        }
        try {
            if (update) {
                this.connectionCombo.removeAll();
                this.connectionCombo.addItem(null);
            }
            int selectionIndex = 0;
            if (this.activePart != null) {
                DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
                if (!CommonUtils.isEmpty(dataSources)) {
                    int i = 0;
                    while (i < dataSources.size()) {
                        DBPDataSourceContainer ds = dataSources.get(i);
                        if (ds != null) {
                            if (update) {
                                this.connectionCombo.addItem(ds);
                            }
                            if (dataSourceContainer == ds) {
                                selectionIndex = i + 1;
                            }
                        }
                        ++i;
                    }
                }
            }
            this.connectionCombo.select(selectionIndex);
            this.connectionCombo.setToolTipText(String.valueOf(UINavigatorMessages.toolbar_datasource_selector_combo_datasource_tooltip) + "\n" + this.connectionCombo.getText());
        }
        finally {
            if (update) {
                this.connectionCombo.setRedraw(true);
            }
        }
    }

    public void handleDataSourceEvent(DBPEvent event) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        if (event.getAction() == DBPEvent.Action.OBJECT_ADD || event.getAction() == DBPEvent.Action.OBJECT_REMOVE || event.getAction() == DBPEvent.Action.OBJECT_UPDATE && event.getObject() == this.getDataSourceContainer() || event.getAction() == DBPEvent.Action.OBJECT_SELECT && Boolean.TRUE.equals(event.getEnabled()) && DBUtils.getContainer((DBSObject)event.getObject()) == this.getDataSourceContainer()) {
            UIUtils.asyncExec(() -> this.updateControls(true));
        }
        if (event.getAction() == DBPEvent.Action.OBJECT_UPDATE && event.getEnabled() != null) {
            UIUtils.asyncExec(() -> {
                IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                if (workbenchWindow instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)workbenchWindow).updateActionBars();
                }
            });
        }
    }

    private void updateControls(boolean force) {
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (this.resultSetSize != null && !this.resultSetSize.isDisposed()) {
            if (dataSourceContainer == null) {
                this.resultSetSize.setEnabled(false);
                this.resultSetSize.setText("");
            } else {
                this.resultSetSize.setEnabled(true);
                this.resultSetSize.setText(String.valueOf(200));
            }
        }
        this.updateDataSourceList(force);
        this.updateDatabaseList(force);
    }

    private void changeResultSetSize() {
        String rsSize;
        DBPDataSourceContainer dsContainer = this.getDataSourceContainer();
        if (dsContainer != null && (rsSize = this.resultSetSize.getText()).length() == 0) {
            String string = "1";
        }
    }

    private void updateDataSourceList(boolean force) {
        if (this.connectionCombo != null && !this.connectionCombo.isDisposed()) {
            IDataSourceContainerProviderEx containerProvider = this.getActiveDataSourceUpdater();
            if (containerProvider == null) {
                this.connectionCombo.removeAll();
                this.connectionCombo.setEnabled(false);
            } else {
                this.connectionCombo.setEnabled(true);
            }
            this.fillDataSourceList(force);
        }
    }

    private void updateDatabaseList(boolean force) {
        if (!force) {
            DBPDataSourceContainer dsContainer = this.getDataSourceContainer();
            if (this.curDataSourceContainer != null && dsContainer == this.curDataSourceContainer.get()) {
                return;
            }
        }
        this.fillDatabaseCombo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillDatabaseCombo() {
        if (this.databaseCombo != null && !this.databaseCombo.isDisposed()) {
            DBPDataSourceContainer dsContainer = this.getDataSourceContainer();
            this.databaseCombo.setEnabled(dsContainer != null);
            if (dsContainer != null && dsContainer.isConnected()) {
                DBPDataSource dataSource = dsContainer.getDataSource();
                if (dataSource != null) {
                    List<DatabaseListReader> list = this.dbListReads;
                    synchronized (list) {
                        for (DatabaseListReader reader : this.dbListReads) {
                            if (reader.getExecutionContext().getDataSource() != dataSource) continue;
                            return;
                        }
                        DatabaseListReader databaseReader = new DatabaseListReader(dataSource.getDefaultInstance().getDefaultContext(true));
                        databaseReader.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                UIUtils.syncExec(() -> DataSourceManagementToolbar.this.fillDatabaseList((DatabaseListReader)event.getJob()));
                            }
                        });
                        this.dbListReads.add(databaseReader);
                        databaseReader.schedule();
                    }
                }
                this.curDataSourceContainer = new SoftReference<DBPDataSourceContainer>(dsContainer);
            } else {
                this.curDataSourceContainer = null;
                this.databaseCombo.removeAll();
                this.databaseCombo.setToolTipText(UINavigatorMessages.toolbar_datasource_selector_combo_database_tooltip);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fillDatabaseList(DatabaseListReader reader) {
        List<DatabaseListReader> list = this.dbListReads;
        synchronized (list) {
            this.dbListReads.remove((Object)reader);
        }
        if (this.databaseCombo.isDisposed()) {
            return;
        }
        this.databaseCombo.setRedraw(false);
        try {
            this.databaseCombo.removeAll();
            if (reader.active == null) {
                this.databaseCombo.addItem(null);
            }
            if (!reader.enabled) {
                this.databaseCombo.setEnabled(false);
                return;
            }
            List dbList = reader.nodeList;
            if (dbList != null && !dbList.isEmpty()) {
                for (DBNDatabaseNode node : dbList) {
                    this.databaseCombo.addItem((Object)node);
                }
            }
            if (reader.active != null) {
                int dbCount = this.databaseCombo.getItemCount();
                int i = 0;
                while (i < dbCount) {
                    if (this.databaseCombo.getItem(i) != null && ((DBNDatabaseNode)this.databaseCombo.getItem(i)).getObject() == reader.active) {
                        this.databaseCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.databaseCombo.setEnabled(reader.enabled);
            this.databaseCombo.setToolTipText(String.valueOf(UINavigatorMessages.toolbar_datasource_selector_combo_database_tooltip) + "\n" + this.databaseCombo.getText());
        }
        finally {
            if (!this.databaseCombo.isDisposed()) {
                this.databaseCombo.setRedraw(true);
            }
        }
    }

    private void changeDataSourceSelection(final DBPDataSourceContainer selectedDataSource) {
        if (this.connectionCombo == null || this.connectionCombo.isDisposed()) {
            return;
        }
        final IDataSourceContainerProviderEx dataSourceUpdater = this.getActiveDataSourceUpdater();
        if (dataSourceUpdater == null) {
            return;
        }
        AbstractJob updateJob = new AbstractJob("Change active database"){

            protected IStatus run(DBRProgressMonitor monitor) {
                dataSourceUpdater.setDataSourceContainer(selectedDataSource);
                return Status.OK_STATUS;
            }
        };
        updateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UIUtils.asyncExec(() -> DataSourceManagementToolbar.this.updateControls(false));
            }
        });
        updateJob.schedule();
    }

    private void changeDataBaseSelection(final @Nullable String newInstanceName, @NotNull DBNDatabaseNode node) {
        DBPDataSourceContainer dsContainer = this.getDataSourceContainer();
        final String newName = node.getNodeName();
        if (dsContainer != null && dsContainer.isConnected()) {
            final DBPDataSource dataSource = dsContainer.getDataSource();
            new AbstractJob("Change active database"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        DBSObject newChild;
                        DBSObjectContainer oc = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
                        DBSObjectSelector os = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)dataSource);
                        if (os != null) {
                            DBSObjectSelector os2;
                            DBSObject defObject;
                            DBSObject newInstance;
                            if (newInstanceName != null && !CommonUtils.equalObjects((Object)DataSourceManagementToolbar.this.currentDatabaseInstanceName, (Object)newInstanceName) && (newInstance = oc.getChild(monitor, newInstanceName)) != null) {
                                os.setDefaultObject(monitor, newInstance);
                            }
                            if ((defObject = os.getDefaultObject()) instanceof DBSObjectContainer && (os2 = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)defObject)) != null && os2.supportsDefaultChange()) {
                                oc = (DBSObjectContainer)defObject;
                                os = os2;
                            }
                        }
                        if (oc != null && os != null && os.supportsDefaultChange()) {
                            newChild = oc.getChild(monitor, newName);
                            if (newChild == null) {
                                throw new DBException(MessageFormat.format(UINavigatorMessages.toolbar_datasource_selector_error_database_not_found, newName));
                            }
                        } else {
                            throw new DBException(UINavigatorMessages.toolbar_datasource_selector_error_database_change_not_supported);
                        }
                        os.setDefaultObject(monitor, newChild);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
    }

    Control createControl(Composite parent) {
        this.workbenchWindow.addPageListener(this.pageListener);
        IWorkbenchPage activePage = this.workbenchWindow.getActivePage();
        if (activePage != null) {
            this.pageListener.pageOpened(activePage);
        }
        DataSourceProviderRegistry.getInstance().addDataSourceRegistryListener((DBPRegistryListener)this);
        for (DBPDataSourceRegistry registry : DBUtils.getAllRegistries()) {
            this.handleRegistryLoad(registry);
        }
        Composite comboGroup = new Composite(parent, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        comboGroup.setLayout((Layout)layout);
        int fontHeight = UIUtils.getFontHeight((Control)parent);
        int comboWidth = fontHeight * 20;
        this.connectionCombo = new SelectDataSourceCombo(comboGroup){

            @Override
            protected IProject getActiveProject() {
                return DataSourceManagementToolbar.this.getActiveProject();
            }

            @Override
            protected void onDataSourceChange(DBPDataSourceContainer dataSource) {
                DataSourceManagementToolbar.this.changeDataSourceSelection(dataSource);
            }
        };
        RowData rd = new RowData();
        rd.width = comboWidth;
        this.connectionCombo.setLayoutData(rd);
        this.connectionCombo.setVisibleItemCount(15);
        this.connectionCombo.setWidthHint(comboWidth);
        this.connectionCombo.setToolTipText(UINavigatorMessages.toolbar_datasource_selector_combo_datasource_tooltip);
        this.connectionCombo.addItem(null);
        this.connectionCombo.select(0);
        comboWidth = fontHeight * 20;
        this.databaseCombo = new CSmartSelector<DBNDatabaseNode>(comboGroup, 2060, (ILabelProvider)new DatabaseLabelProviders.DatabaseLabelProvider(){

            @Override
            public String getText(Object element) {
                if (DataSourceManagementToolbar.this.currentDatabaseInstanceName == null) {
                    return super.getText(element);
                }
                return String.valueOf(super.getText(element)) + "@" + DataSourceManagementToolbar.this.currentDatabaseInstanceName;
            }
        }){

            protected void dropDown(boolean drop) {
                if (!drop) {
                    return;
                }
                DataSourceManagementToolbar.this.showDatabaseSelector();
            }
        };
        rd = new RowData();
        rd.width = comboWidth;
        this.databaseCombo.setLayoutData((Object)rd);
        this.databaseCombo.setVisibleItemCount(15);
        this.databaseCombo.setWidthHint(comboWidth);
        this.databaseCombo.setToolTipText(UINavigatorMessages.toolbar_datasource_selector_combo_database_tooltip);
        this.databaseCombo.addItem(null);
        this.databaseCombo.select(0);
        this.resultSetSize = new Text(comboGroup, 2048);
        this.resultSetSize.setTextLimit(10);
        rd = new RowData();
        rd.width = fontHeight * 4;
        this.resultSetSize.setLayoutData((Object)rd);
        this.resultSetSize.setToolTipText(UINavigatorMessages.toolbar_datasource_selector_resultset_segment_size);
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        this.resultSetSize.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.resultSetSize.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DataSourceManagementToolbar.this.changeResultSetSize();
            }
        });
        comboGroup.addDisposeListener(e -> this.dispose());
        UIUtils.asyncExec(() -> {
            if (this.workbenchWindow != null && this.workbenchWindow.getActivePage() != null) {
                this.setActivePart(this.workbenchWindow.getActivePage().getActivePart());
            }
        });
        return comboGroup;
    }

    void showDatabaseSelector() {
        DBNDatabaseNode selectedDB = (DBNDatabaseNode)this.databaseCombo.getSelectedItem();
        ArrayList<DBNDatabaseNode> items = new ArrayList<DBNDatabaseNode>(this.databaseCombo.getItems());
        items.removeIf(Objects::isNull);
        if (items.isEmpty()) {
            return;
        }
        DBPDataSourceContainer dataSourceContainer = (DBPDataSourceContainer)this.connectionCombo.getSelectedItem();
        SelectDatabaseDialog dialog = new SelectDatabaseDialog(this.databaseCombo.getShell(), dataSourceContainer, this.currentDatabaseInstanceName, items, selectedDB == null ? null : Collections.singletonList(selectedDB));
        dialog.setModeless(true);
        if (dialog.open() == 1) {
            return;
        }
        DBNDatabaseNode node = (DBNDatabaseNode)dialog.getSelectedObject();
        if (node != null && node != this.databaseCombo.getSelectedItem()) {
            this.databaseCombo.select((Object)node);
            this.changeDataBaseSelection(dialog.getCurrentInstanceName(), node);
        }
    }

    public void nodeChanged(DBNEvent event) {
        int selConnection;
        if (this.activeFile == null) {
            return;
        }
        DBNNode node = event.getNode();
        if (node instanceof DBNResource && this.activeFile.equals((Object)((DBNResource)node).getResource()) && (selConnection = this.connectionCombo.getSelectionIndex()) > 0 && this.activeFile != null) {
            DBPDataSourceContainer visibleContainer = (DBPDataSourceContainer)this.connectionCombo.getItem(selConnection);
            DBPDataSourceContainer newContainer = EditorUtils.getFileDataSource((IFile)this.activeFile);
            if (newContainer != visibleContainer) {
                this.updateControls(true);
            }
        }
    }

    private class DatabaseListReader
    extends DataSourceJob {
        private final List<DBNDatabaseNode> nodeList;
        private DBSObject active;
        private boolean enabled;

        DatabaseListReader(DBCExecutionContext context) {
            super(UINavigatorMessages.toolbar_datasource_selector_action_read_databases, context);
            this.nodeList = new ArrayList<DBNDatabaseNode>();
            this.setSystem(true);
            this.enabled = false;
        }

        public IStatus run(DBRProgressMonitor monitor) {
            DBPDataSource dataSource = this.getExecutionContext().getDataSource();
            DBSObjectContainer objectContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
            DBSObjectSelector objectSelector = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)dataSource);
            if (objectContainer == null || objectSelector == null) {
                return Status.CANCEL_STATUS;
            }
            try {
                try {
                    monitor.beginTask(UINavigatorMessages.toolbar_datasource_selector_action_read_databases, 1);
                    DataSourceManagementToolbar.this.currentDatabaseInstanceName = null;
                    Class childType = objectContainer.getChildType(monitor);
                    if (childType == null || !DBSObjectContainer.class.isAssignableFrom(childType)) {
                        this.enabled = false;
                    } else {
                        this.enabled = true;
                        DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
                        DBSObject defObject = objectSelector.getDefaultObject();
                        if (defObject instanceof DBSObjectContainer && (objectSelector = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)defObject)) != null && objectSelector.supportsDefaultChange()) {
                            DataSourceManagementToolbar.this.currentDatabaseInstanceName = defObject.getName();
                            objectContainer = (DBSObjectContainer)defObject;
                            defObject = objectSelector.getDefaultObject();
                        }
                        Collection children = objectContainer.getChildren(monitor);
                        this.active = defObject;
                        if (children != null) {
                            for (DBSObject child : children) {
                                DBNDatabaseNode node;
                                if (DBUtils.getAdapter(DBSObjectContainer.class, (Object)child) == null || (node = navigatorModel.getNodeByObject(monitor, child, false)) == null) continue;
                                this.nodeList.add(node);
                            }
                        }
                    }
                }
                catch (DBException e) {
                    IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    public static class ToolbarContribution
    extends WorkbenchWindowControlContribution {
        public ToolbarContribution() {
            super("datasource-settings");
        }

        protected Control createControl(Composite parent) {
            DataSourceManagementToolbar toolbar = new DataSourceManagementToolbar(UIUtils.getActiveWorkbenchWindow());
            return toolbar.createControl(parent);
        }
    }
}

